/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Update;

public class SqlSegmentsMetadataQuery {
    private static final Logger log = new Logger(SqlSegmentsMetadataQuery.class);
    private final Handle handle;
    private final SQLMetadataConnector connector;
    private final MetadataStorageTablesConfig dbTables;
    private final ObjectMapper jsonMapper;

    private SqlSegmentsMetadataQuery(Handle handle, SQLMetadataConnector connector, MetadataStorageTablesConfig dbTables, ObjectMapper jsonMapper) {
        this.handle = handle;
        this.connector = connector;
        this.dbTables = dbTables;
        this.jsonMapper = jsonMapper;
    }

    public static SqlSegmentsMetadataQuery forHandle(Handle handle, SQLMetadataConnector connector, MetadataStorageTablesConfig dbTables, ObjectMapper jsonMapper) {
        return new SqlSegmentsMetadataQuery(handle, connector, dbTables, jsonMapper);
    }

    public CloseableIterator<DataSegment> retrieveUsedSegments(String dataSource, Collection<Interval> intervals) {
        return this.retrieveSegments(dataSource, intervals, IntervalMode.OVERLAPS, true);
    }

    public CloseableIterator<DataSegment> retrieveUnusedSegments(String dataSource, Collection<Interval> intervals) {
        return this.retrieveSegments(dataSource, intervals, IntervalMode.CONTAINS, false);
    }

    public int markSegments(Collection<SegmentId> segmentIds, boolean used) {
        if (segmentIds.isEmpty()) {
            return 0;
        }
        String dataSource = segmentIds.iterator().next().getDataSource();
        if (segmentIds.stream().anyMatch(segment -> !dataSource.equals(segment.getDataSource()))) {
            throw new IAE("Segments to drop must all be part of the same datasource", new Object[0]);
        }
        PreparedBatch batch = this.handle.prepareBatch(StringUtils.format((String)"UPDATE %s SET used = ? WHERE datasource = ? AND id = ?", (Object[])new Object[]{this.dbTables.getSegmentsTable()}));
        for (SegmentId segmentId : segmentIds) {
            batch.add(new Object[]{used, dataSource, segmentId.toString()});
        }
        int[] segmentChanges = batch.execute();
        return SqlSegmentsMetadataQuery.computeNumChangedSegments(segmentIds.stream().map(SegmentId::toString).collect(Collectors.toList()), segmentChanges);
    }

    public int markSegmentsUnused(String dataSource, Interval interval) {
        if (Intervals.isEternity((Interval)interval)) {
            return ((Update)((Update)this.handle.createStatement(StringUtils.format((String)"UPDATE %s SET used=:used WHERE dataSource = :dataSource", (Object[])new Object[]{this.dbTables.getSegmentsTable()})).bind("dataSource", dataSource)).bind("used", false)).execute();
        }
        if (Intervals.canCompareEndpointsAsStrings((Interval)interval) && interval.getStart().getYear() == interval.getEnd().getYear()) {
            return ((Update)((Update)((Update)((Update)this.handle.createStatement(StringUtils.format((String)"UPDATE %s SET used=:used WHERE dataSource = :dataSource AND %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), IntervalMode.CONTAINS.makeSqlCondition(this.connector.getQuoteString(), ":start", ":end")})).bind("dataSource", dataSource)).bind("used", false)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).execute();
        }
        ImmutableList segments = ImmutableList.copyOf((Iterator)Iterators.transform(this.retrieveSegments(dataSource, Collections.singletonList(interval), IntervalMode.CONTAINS, true), DataSegment::getId));
        return this.markSegments((Collection<SegmentId>)segments, false);
    }

    private CloseableIterator<DataSegment> retrieveSegments(String dataSource, Collection<Interval> intervals, IntervalMode matchMode, boolean used) {
        boolean compareAsString = intervals.stream().allMatch(Intervals::canCompareEndpointsAsStrings);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT payload FROM %s WHERE used = :used AND dataSource = :dataSource");
        if (compareAsString && !intervals.isEmpty()) {
            sb.append(" AND (");
            for (int i = 0; i < intervals.size(); ++i) {
                sb.append(matchMode.makeSqlCondition(this.connector.getQuoteString(), StringUtils.format((String)":start%d", (Object[])new Object[]{i}), StringUtils.format((String)":end%d", (Object[])new Object[]{i})));
                if (i == intervals.size() - 1) {
                    sb.append(")");
                    continue;
                }
                sb.append(" OR ");
            }
        }
        Query sql = (Query)((Query)this.handle.createQuery(StringUtils.format((String)sb.toString(), (Object[])new Object[]{this.dbTables.getSegmentsTable()})).setFetchSize(this.connector.getStreamingFetchSize()).bind("used", used)).bind("dataSource", dataSource);
        if (compareAsString) {
            Iterator<Interval> iterator = intervals.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Interval interval = iterator.next();
                ((Query)sql.bind(StringUtils.format((String)"start%d", (Object[])new Object[]{i}), interval.getStart().toString())).bind(StringUtils.format((String)"end%d", (Object[])new Object[]{i}), interval.getEnd().toString());
                ++i;
            }
        }
        ResultIterator resultIterator = sql.map((index, r, ctx) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class)).iterator();
        return CloseableIterators.wrap((Iterator)Iterators.filter((Iterator)resultIterator, dataSegment -> {
            if (intervals.isEmpty()) {
                return true;
            }
            for (Interval interval : intervals) {
                if (!matchMode.apply(interval, dataSegment.getInterval())) continue;
                return true;
            }
            return false;
        }), (Closeable)resultIterator);
    }

    private static int computeNumChangedSegments(List<String> segmentIds, int[] segmentChanges) {
        int numChangedSegments = 0;
        for (int i = 0; i < segmentChanges.length; ++i) {
            int numUpdatedRows = segmentChanges[i];
            if (numUpdatedRows < 0) {
                log.assertionError("Negative number of rows updated for segment id [%s]: %d", new Object[]{segmentIds.get(i), numUpdatedRows});
            } else if (numUpdatedRows > 1) {
                log.error("More than one row updated for segment id [%s]: %d, there may be more than one row for the segment id in the database", new Object[]{segmentIds.get(i), numUpdatedRows});
            }
            if (numUpdatedRows <= 0) continue;
            ++numChangedSegments;
        }
        return numChangedSegments;
    }

    static enum IntervalMode {
        CONTAINS{

            @Override
            public String makeSqlCondition(String quoteString, String startPlaceholder, String endPlaceholder) {
                return StringUtils.format((String)"(start >= %2$s and start <= %3$s and %1$send%1$s <= %3$s)", (Object[])new Object[]{quoteString, startPlaceholder, endPlaceholder});
            }

            @Override
            public boolean apply(Interval a, Interval b) {
                return a.contains((ReadableInterval)b);
            }
        }
        ,
        OVERLAPS{

            @Override
            public String makeSqlCondition(String quoteString, String startPlaceholder, String endPlaceholder) {
                return StringUtils.format((String)"(start < %3$s AND %1$send%1$s > %2$s)", (Object[])new Object[]{quoteString, startPlaceholder, endPlaceholder});
            }

            @Override
            public boolean apply(Interval a, Interval b) {
                return a.overlaps((ReadableInterval)b);
            }
        };


        public abstract String makeSqlCondition(String var1, String var2, String var3);

        public abstract boolean apply(Interval var1, Interval var2);
    }
}

