/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.druid.curator.CuratorModule;
import org.apache.druid.curator.discovery.DiscoveryModule;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.AnnouncerModule;
import org.apache.druid.guice.CoordinatorDiscoveryModule;
import org.apache.druid.guice.DruidProcessingConfigModule;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.FirehoseModule;
import org.apache.druid.guice.IndexingServiceDiscoveryModule;
import org.apache.druid.guice.JacksonConfigManagerModule;
import org.apache.druid.guice.JavaScriptModule;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.LocalDataStorageDruidModule;
import org.apache.druid.guice.MetadataConfigModule;
import org.apache.druid.guice.ModulesConfig;
import org.apache.druid.guice.ServerModule;
import org.apache.druid.guice.ServerViewModule;
import org.apache.druid.guice.StartupLoggingModule;
import org.apache.druid.guice.StorageNodeModule;
import org.apache.druid.guice.annotations.Client;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.guice.http.HttpClientModule;
import org.apache.druid.guice.security.AuthenticatorModule;
import org.apache.druid.guice.security.AuthorizerModule;
import org.apache.druid.guice.security.DruidAuthModule;
import org.apache.druid.guice.security.EscalatorModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.initialization.ExtensionFirstClassLoader;
import org.apache.druid.initialization.Log4jShutterDownerModule;
import org.apache.druid.initialization.TombstoneDataStorageModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.storage.derby.DerbyMetadataStorageDruidModule;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumModule;
import org.apache.druid.server.emitter.EmitterModule;
import org.apache.druid.server.initialization.AuthenticatorMapperModule;
import org.apache.druid.server.initialization.AuthorizerMapperModule;
import org.apache.druid.server.initialization.ExternalStorageAccessSecurityModule;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.druid.server.security.TLSCertificateCheckerModule;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Initialization {
    private static final Logger log = new Logger(Initialization.class);
    private static final ConcurrentHashMap<File, URLClassLoader> LOADERS_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Collection<?>> EXTENSIONS_MAP = new ConcurrentHashMap();

    public static <T> Collection<T> getLoadedImplementations(Class<T> clazz) {
        Collection<?> retVal = EXTENSIONS_MAP.get(clazz);
        if (retVal == null) {
            return new HashSet();
        }
        return retVal;
    }

    @VisibleForTesting
    static void clearLoadedImplementations() {
        EXTENSIONS_MAP.clear();
    }

    @VisibleForTesting
    static Map<File, URLClassLoader> getLoadersMap() {
        return LOADERS_MAP;
    }

    public static <T> Collection<T> getFromExtensions(ExtensionsConfig config, Class<T> serviceClass) {
        Collection modules = EXTENSIONS_MAP.compute(serviceClass, (serviceC, ignored) -> new ServiceLoadingFromExtensions(config, (Class)serviceC).implsToLoad);
        return modules;
    }

    public static File[] getExtensionFilesToLoad(ExtensionsConfig config) {
        File[] extensionsToLoad;
        File rootExtensionsDir = new File(config.getDirectory());
        if (rootExtensionsDir.exists() && !rootExtensionsDir.isDirectory()) {
            throw new ISE("Root extensions directory [%s] is not a directory!?", new Object[]{rootExtensionsDir});
        }
        LinkedHashSet toLoad = config.getLoadList();
        if (toLoad == null) {
            extensionsToLoad = rootExtensionsDir.listFiles();
        } else {
            int i = 0;
            extensionsToLoad = new File[toLoad.size()];
            for (String extensionName : toLoad) {
                File extensionDir = new File(extensionName);
                if (!extensionDir.isAbsolute()) {
                    extensionDir = new File(rootExtensionsDir, extensionName);
                }
                if (!extensionDir.isDirectory()) {
                    throw new ISE("Extension [%s] specified in \"druid.extensions.loadList\" didn't exist!?", new Object[]{extensionDir.getAbsolutePath()});
                }
                extensionsToLoad[i++] = extensionDir;
            }
        }
        return extensionsToLoad == null ? new File[]{} : extensionsToLoad;
    }

    public static File[] getHadoopDependencyFilesToLoad(List<String> hadoopDependencyCoordinates, ExtensionsConfig extensionsConfig) {
        File rootHadoopDependenciesDir = new File(extensionsConfig.getHadoopDependenciesDir());
        if (rootHadoopDependenciesDir.exists() && !rootHadoopDependenciesDir.isDirectory()) {
            throw new ISE("Root Hadoop dependencies directory [%s] is not a directory!?", new Object[]{rootHadoopDependenciesDir});
        }
        File[] hadoopDependenciesToLoad = new File[hadoopDependencyCoordinates.size()];
        int i = 0;
        for (String coordinate : hadoopDependencyCoordinates) {
            DefaultArtifact artifact = new DefaultArtifact(coordinate);
            File hadoopDependencyDir = new File(rootHadoopDependenciesDir, artifact.getArtifactId());
            File versionDir = new File(hadoopDependencyDir, artifact.getVersion());
            if (!hadoopDependencyDir.isDirectory() || !versionDir.isDirectory()) {
                throw new ISE("Hadoop dependency [%s] didn't exist!?", new Object[]{versionDir.getAbsolutePath()});
            }
            hadoopDependenciesToLoad[i++] = versionDir;
        }
        return hadoopDependenciesToLoad;
    }

    public static URLClassLoader getClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst) {
        return LOADERS_MAP.computeIfAbsent(extension, theExtension -> Initialization.makeClassLoaderForExtension(theExtension, useExtensionClassloaderFirst));
    }

    private static URLClassLoader makeClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst) {
        Collection jars = FileUtils.listFiles((File)extension, (String[])new String[]{"jar"}, (boolean)false);
        URL[] urls = new URL[jars.size()];
        try {
            int i = 0;
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                log.debug("added URL[%s] for extension[%s]", new Object[]{url, extension.getName()});
                urls[i++] = url;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (useExtensionClassloaderFirst) {
            return new ExtensionFirstClassLoader(urls, Initialization.class.getClassLoader());
        }
        return new URLClassLoader(urls, Initialization.class.getClassLoader());
    }

    public static List<URL> getURLsForClasspath(String cp) {
        try {
            String[] paths = cp.split(File.pathSeparator);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths) {
                File f = new File(path);
                if ("*".equals(f.getName())) {
                    File[] jars;
                    File parentDir = f.getParentFile();
                    if (!parentDir.isDirectory()) continue;
                    for (File jar : jars = parentDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && (name.endsWith(".jar") || name.endsWith(".JAR"));
                        }
                    })) {
                        urls.add(jar.toURI().toURL());
                    }
                    continue;
                }
                urls.add(new File(path).toURI().toURL());
            }
            return urls;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Injector makeInjectorWithModules(Injector baseInjector, Iterable<? extends Module> modules) {
        return Initialization.makeInjectorWithModules((Set<NodeRole>)ImmutableSet.of(), baseInjector, modules);
    }

    public static Injector makeInjectorWithModules(Set<NodeRole> nodeRoles, Injector baseInjector, Iterable<? extends Module> modules) {
        ModuleList defaultModules = new ModuleList(baseInjector, nodeRoles);
        defaultModules.addModules(new Object[]{new Log4jShutterDownerModule(), new DruidAuthModule(), new LifecycleModule(), TLSCertificateCheckerModule.class, EmitterModule.class, HttpClientModule.global(), HttpClientModule.escalatedGlobal(), new HttpClientModule("druid.broker.http", Client.class), new HttpClientModule("druid.broker.http", EscalatedClient.class), new CuratorModule(), new AnnouncerModule(), new MetricsModule(), new SegmentWriteOutMediumModule(), new ServerModule(), new DruidProcessingConfigModule(), new StorageNodeModule(), new JettyServerModule(), new ExpressionModule(), new DiscoveryModule(), new ServerViewModule(), new MetadataConfigModule(), new DerbyMetadataStorageDruidModule(), new JacksonConfigManagerModule(), new IndexingServiceDiscoveryModule(), new CoordinatorDiscoveryModule(), new LocalDataStorageDruidModule(), new TombstoneDataStorageModule(), new FirehoseModule(), new JavaScriptModule(), new AuthenticatorModule(), new AuthenticatorMapperModule(), new EscalatorModule(), new AuthorizerModule(), new AuthorizerMapperModule(), new StartupLoggingModule(), new ExternalStorageAccessSecurityModule()});
        ModuleList actualModules = new ModuleList(baseInjector, nodeRoles);
        actualModules.addModule(DruidSecondaryModule.class);
        for (Module module : modules) {
            actualModules.addModule(module);
        }
        Module intermediateModules = Modules.override((Iterable)defaultModules.getModules()).with((Iterable)actualModules.getModules());
        ModuleList moduleList = new ModuleList(baseInjector, nodeRoles);
        ExtensionsConfig config = (ExtensionsConfig)baseInjector.getInstance(ExtensionsConfig.class);
        for (DruidModule module : Initialization.getFromExtensions(config, DruidModule.class)) {
            moduleList.addModule(module);
        }
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{intermediateModules}).with((Iterable)moduleList.getModules())});
    }

    private static class ModuleList {
        private final Injector baseInjector;
        private final Set<NodeRole> nodeRoles;
        private final ModulesConfig modulesConfig;
        private final ObjectMapper jsonMapper;
        private final ObjectMapper smileMapper;
        private final List<Module> modules;

        public ModuleList(Injector baseInjector, Set<NodeRole> nodeRoles) {
            this.baseInjector = baseInjector;
            this.nodeRoles = nodeRoles;
            this.modulesConfig = (ModulesConfig)baseInjector.getInstance(ModulesConfig.class);
            this.jsonMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
            this.smileMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Smile.class));
            this.modules = new ArrayList<Module>();
        }

        private List<Module> getModules() {
            return Collections.unmodifiableList(this.modules);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void addModule(Object input) {
            if (!this.shouldLoadOnCurrentNodeType(input)) {
                return;
            }
            if (input instanceof DruidModule) {
                if (!this.checkModuleClass(input.getClass())) {
                    return;
                }
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)this.registerJacksonModules((DruidModule)input));
                return;
            } else if (input instanceof Module) {
                if (!this.checkModuleClass(input.getClass())) {
                    return;
                }
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)input);
                return;
            } else {
                if (!(input instanceof Class)) throw new ISE("Unknown module type[%s]", new Object[]{input.getClass()});
                if (!this.checkModuleClass((Class)input)) {
                    return;
                }
                if (DruidModule.class.isAssignableFrom((Class)input)) {
                    this.modules.add((Module)this.registerJacksonModules((DruidModule)this.baseInjector.getInstance((Class)input)));
                    return;
                } else {
                    if (!Module.class.isAssignableFrom((Class)input)) throw new ISE("Class[%s] does not implement %s", new Object[]{input.getClass(), Module.class});
                    this.modules.add((Module)this.baseInjector.getInstance((Class)input));
                    return;
                }
            }
        }

        private boolean shouldLoadOnCurrentNodeType(Object object) {
            LoadScope loadScope = object.getClass().getAnnotation(LoadScope.class);
            if (loadScope == null) {
                return true;
            }
            Set rolesPredicate = Arrays.stream(loadScope.roles()).map(NodeRole::fromJsonName).collect(Collectors.toSet());
            return rolesPredicate.stream().anyMatch(this.nodeRoles::contains);
        }

        private boolean checkModuleClass(Class<?> moduleClass) {
            String moduleClassName = moduleClass.getName();
            if (moduleClassName != null && this.modulesConfig.getExcludeList().contains(moduleClassName)) {
                log.info("Not loading module [%s] because it is present in excludeList", new Object[]{moduleClassName});
                return false;
            }
            return true;
        }

        public void addModules(Object ... object) {
            for (Object o : object) {
                this.addModule(o);
            }
        }

        private DruidModule registerJacksonModules(DruidModule module) {
            for (com.fasterxml.jackson.databind.Module jacksonModule : module.getJacksonModules()) {
                this.jsonMapper.registerModule(jacksonModule);
                this.smileMapper.registerModule(jacksonModule);
            }
            return module;
        }
    }

    private static class ServiceLoadingFromExtensions<T> {
        private final ExtensionsConfig extensionsConfig;
        private final Class<T> serviceClass;
        private final List<T> implsToLoad = new ArrayList<T>();
        private final Set<String> implClassNamesToLoad = new HashSet<String>();

        private ServiceLoadingFromExtensions(ExtensionsConfig extensionsConfig, Class<T> serviceClass) {
            this.extensionsConfig = extensionsConfig;
            this.serviceClass = serviceClass;
            if (extensionsConfig.searchCurrentClassloader()) {
                this.addAllFromCurrentClassLoader();
            }
            this.addAllFromFileSystem();
        }

        private void addAllFromCurrentClassLoader() {
            ServiceLoader.load(this.serviceClass, Thread.currentThread().getContextClassLoader()).forEach(impl -> this.tryAdd(impl, "classpath"));
        }

        private void addAllFromFileSystem() {
            for (File extension : Initialization.getExtensionFilesToLoad(this.extensionsConfig)) {
                log.debug("Loading extension [%s] for class [%s]", new Object[]{extension.getName(), this.serviceClass});
                try {
                    URLClassLoader loader = Initialization.getClassLoaderForExtension(extension, this.extensionsConfig.isUseExtensionClassloaderFirst());
                    log.info("Loading extension [%s], jars: %s", new Object[]{extension.getName(), Arrays.stream(loader.getURLs()).map(u -> new File(u.getPath()).getName()).collect(Collectors.joining(", "))});
                    ServiceLoader.load(this.serviceClass, loader).forEach(impl -> this.tryAdd(impl, "local file system"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void tryAdd(T serviceImpl, String extensionType) {
            String serviceImplName = serviceImpl.getClass().getName();
            if (serviceImplName == null) {
                log.warn("Implementation [%s] was ignored because it doesn't have a canonical name, is it a local or anonymous class?", new Object[]{serviceImpl.getClass().getName()});
            } else if (!this.implClassNamesToLoad.contains(serviceImplName)) {
                log.debug("Adding implementation [%s] for class [%s] from %s extension", new Object[]{serviceImplName, this.serviceClass, extensionType});
                this.implClassNamesToLoad.add(serviceImplName);
                this.implsToLoad.add(serviceImpl);
            }
        }
    }
}

