/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.parsers.ParserUtils;

public class ClientCompactionTaskDimensionsSpec {
    @Nullable
    private final List<DimensionSchema> dimensions;

    @JsonCreator
    public ClientCompactionTaskDimensionsSpec(@Nullable @JsonProperty(value="dimensions") List<DimensionSchema> dimensions) {
        if (dimensions != null) {
            List dimensionNames = dimensions.stream().map(DimensionSchema::getName).collect(Collectors.toList());
            ParserUtils.validateFields(dimensionNames);
        }
        this.dimensions = dimensions;
    }

    @Nullable
    @JsonProperty
    public List<DimensionSchema> getDimensions() {
        return this.dimensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionTaskDimensionsSpec that = (ClientCompactionTaskDimensionsSpec)o;
        return Objects.equals(this.dimensions, that.dimensions);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions);
    }

    public String toString() {
        return "ClientCompactionTaskDimensionsSpec{dimensions=" + this.dimensions + '}';
    }
}

