/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import org.apache.druid.server.security.AuthValidator;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AuthValidatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    public AuthValidator target;

    @Before
    public void setUp() {
        this.target = new AuthValidator();
    }

    @Test
    public void testAuthorizerNameWithEmptyIsInvalid() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("authorizerName cannot be null or empty.");
        this.target.validateAuthorizerName("");
    }

    @Test
    public void testAuthorizerNameWithNullIsInvalid() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("authorizerName cannot be null or empty.");
        this.target.validateAuthorizerName(null);
    }

    @Test
    public void testAuthorizerNameStartsWithDotIsInValid() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("authorizerName cannot start with the '.' character.");
        this.target.validateAuthorizerName(".test");
    }

    @Test
    public void testAuthorizerNameWithSlashIsInvalid() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("authorizerName cannot contain the '/' character.");
        this.target.validateAuthorizerName("tes/t");
    }

    @Test
    public void testAuthorizerNameWithWhitespaceIsInvalid() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("authorizerName cannot contain whitespace character except space.");
        this.target.validateAuthorizerName("tes\tt");
    }

    @Test
    public void testAuthorizerNameWithAllowedCharactersIsValid() {
        this.target.validateAuthorizerName("t.e.$\\, \u0420\u043e\u0441\u0441\u0438\u044f \ud55c\uad6d\u4e2d\u56fd!?");
    }

    @Test
    public void testAuthenticatorNameWithAllowedCharactersIsValid() {
        this.target.validateAuthenticatorName("t.e.$\\, \u0420\u043e\u0441\u0441\u0438\u044f \ud55c\uad6d\u4e2d\u56fd!?");
    }

    @Test
    public void testAuthenticatorNameWithWhitespaceIsInvalid() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("authenticatorName cannot contain whitespace character except space.");
        this.target.validateAuthenticatorName("tes\tt");
    }
}

