/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.QueryCountStatsMonitor;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryCountStatsMonitorTest {
    private QueryCountStatsProvider queryCountStatsProvider;

    @Before
    public void setUp() {
        this.queryCountStatsProvider = new QueryCountStatsProvider(){
            private long successEmitCount = 0L;
            private long failedEmitCount = 0L;
            private long interruptedEmitCount = 0L;
            private long timedOutEmitCount = 0L;

            public long getSuccessfulQueryCount() {
                ++this.successEmitCount;
                return this.successEmitCount;
            }

            public long getFailedQueryCount() {
                this.failedEmitCount += 2L;
                return this.failedEmitCount;
            }

            public long getInterruptedQueryCount() {
                this.interruptedEmitCount += 3L;
                return this.interruptedEmitCount;
            }

            public long getTimedOutQueryCount() {
                this.timedOutEmitCount += 4L;
                return this.timedOutEmitCount;
            }
        };
    }

    @Test
    public void testMonitor() {
        QueryCountStatsMonitor monitor = new QueryCountStatsMonitor(this.queryCountStatsProvider);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        monitor.doMonitor((ServiceEmitter)emitter);
        Map<String, Long> resultMap = emitter.getEvents().stream().collect(Collectors.toMap(event -> (String)event.toMap().get("metric"), event -> (Long)event.toMap().get("value")));
        Assert.assertEquals((long)5L, (long)resultMap.size());
        Assert.assertEquals((long)1L, (long)resultMap.get("query/success/count"));
        Assert.assertEquals((long)2L, (long)resultMap.get("query/failed/count"));
        Assert.assertEquals((long)3L, (long)resultMap.get("query/interrupted/count"));
        Assert.assertEquals((long)4L, (long)resultMap.get("query/timeout/count"));
        Assert.assertEquals((long)10L, (long)resultMap.get("query/count"));
    }
}

