/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ImmutableDruidServerTests;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorRuntimeParamsTestHelpers;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidClusterBuilder;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.UnloadUnusedSegments;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnloadUnusedSegmentsTest {
    private DruidCoordinator coordinator;
    private ImmutableDruidServer historicalServer;
    private ImmutableDruidServer historicalServerTier2;
    private ImmutableDruidServer brokerServer;
    private ImmutableDruidServer indexerServer;
    private LoadQueuePeonTester historicalPeon;
    private LoadQueuePeonTester historicalTier2Peon;
    private LoadQueuePeonTester brokerPeon;
    private LoadQueuePeonTester indexerPeon;
    private DataSegment segment1;
    private DataSegment segment2;
    private DataSegment broadcastSegment;
    private DataSegment realtimeOnlySegment;
    private List<DataSegment> segments;
    private List<DataSegment> segmentsForRealtime;
    private ImmutableDruidDataSource dataSource1;
    private ImmutableDruidDataSource dataSource2;
    private ImmutableDruidDataSource dataSource2ForRealtime;
    private ImmutableDruidDataSource broadcastDatasource;
    private List<ImmutableDruidDataSource> dataSources;
    private List<ImmutableDruidDataSource> dataSourcesForRealtime;
    private Set<String> broadcastDatasourceNames;
    private MetadataRuleManager databaseRuleManager;

    @Before
    public void setUp() {
        this.coordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        this.historicalServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.historicalServerTier2 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.brokerServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.indexerServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.segment1 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment2 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.databaseRuleManager = (MetadataRuleManager)EasyMock.createMock(MetadataRuleManager.class);
        DateTime start1 = DateTimes.of((String)"2012-01-01");
        DateTime start2 = DateTimes.of((String)"2012-02-01");
        DateTime version = DateTimes.of((String)"2012-05-01");
        this.segment1 = new DataSegment("datasource1", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 11L);
        this.segment2 = new DataSegment("datasource2", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        this.realtimeOnlySegment = new DataSegment("datasource2", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        this.broadcastSegment = new DataSegment("broadcastDatasource", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        this.segments = new ArrayList<DataSegment>();
        this.segments.add(this.segment1);
        this.segments.add(this.segment2);
        this.segments.add(this.broadcastSegment);
        this.segmentsForRealtime = new ArrayList<DataSegment>();
        this.segmentsForRealtime.add(this.realtimeOnlySegment);
        this.segmentsForRealtime.add(this.broadcastSegment);
        this.historicalPeon = new LoadQueuePeonTester();
        this.historicalTier2Peon = new LoadQueuePeonTester();
        this.brokerPeon = new LoadQueuePeonTester();
        this.indexerPeon = new LoadQueuePeonTester();
        this.dataSource1 = new ImmutableDruidDataSource("datasource1", Collections.emptyMap(), Collections.singleton(this.segment1));
        this.dataSource2 = new ImmutableDruidDataSource("datasource2", Collections.emptyMap(), Collections.singleton(this.segment2));
        this.broadcastDatasourceNames = Collections.singleton("broadcastDatasource");
        this.broadcastDatasource = new ImmutableDruidDataSource("broadcastDatasource", Collections.emptyMap(), Collections.singleton(this.broadcastSegment));
        this.dataSources = ImmutableList.of((Object)this.dataSource1, (Object)this.dataSource2, (Object)this.broadcastDatasource);
        this.dataSource2ForRealtime = new ImmutableDruidDataSource("datasource2", Collections.emptyMap(), Collections.singleton(this.realtimeOnlySegment));
        this.dataSourcesForRealtime = ImmutableList.of((Object)this.dataSource2ForRealtime, (Object)this.broadcastDatasource);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.coordinator});
        EasyMock.verify((Object[])new Object[]{this.historicalServer});
        EasyMock.verify((Object[])new Object[]{this.historicalServerTier2});
        EasyMock.verify((Object[])new Object[]{this.brokerServer});
        EasyMock.verify((Object[])new Object[]{this.indexerServer});
        EasyMock.verify((Object[])new Object[]{this.databaseRuleManager});
    }

    @Test
    public void test_unloadUnusedSegmentsFromAllServers() {
        UnloadUnusedSegmentsTest.mockDruidServer(this.historicalServer, ServerType.HISTORICAL, "historical", "_default_tier", 30L, 100L, this.segments, this.dataSources);
        UnloadUnusedSegmentsTest.mockDruidServer(this.historicalServerTier2, ServerType.HISTORICAL, "historicalTier2", "tier2", 30L, 100L, this.segments, this.dataSources);
        UnloadUnusedSegmentsTest.mockDruidServer(this.brokerServer, ServerType.BROKER, "broker", "_default_tier", 30L, 100L, this.segments, this.dataSources);
        UnloadUnusedSegmentsTest.mockDruidServer(this.indexerServer, ServerType.INDEXER_EXECUTOR, "indexer", "_default_tier", 30L, 100L, this.segmentsForRealtime, this.dataSourcesForRealtime);
        UnloadUnusedSegmentsTest.mockCoordinator(this.coordinator);
        UnloadUnusedSegmentsTest.mockRuleManager(this.databaseRuleManager);
        ImmutableSet usedSegments = ImmutableSet.of((Object)this.segment2);
        DruidCoordinatorRuntimeParams params = CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(DruidClusterBuilder.newBuilder().addTier("_default_tier", new ServerHolder(this.historicalServer, (LoadQueuePeon)this.historicalPeon, false)).addTier("tier2", new ServerHolder(this.historicalServerTier2, (LoadQueuePeon)this.historicalTier2Peon, false)).withBrokers(new ServerHolder(this.brokerServer, (LoadQueuePeon)this.brokerPeon, false)).withRealtimes(new ServerHolder(this.indexerServer, (LoadQueuePeon)this.indexerPeon, false)).build()).withLoadManagementPeons((Map)ImmutableMap.of((Object)"historical", (Object)((Object)this.historicalPeon), (Object)"historicalTier2", (Object)((Object)this.historicalTier2Peon), (Object)"broker", (Object)((Object)this.brokerPeon), (Object)"indexer", (Object)((Object)this.indexerPeon))).withUsedSegmentsInTest((Collection)usedSegments).withBroadcastDatasources(this.broadcastDatasourceNames).withDatabaseRuleManager(this.databaseRuleManager).build();
        params = new UnloadUnusedSegments().run(params);
        CoordinatorStats stats = params.getCoordinatorStats();
        Assert.assertEquals((long)5L, (long)stats.getTieredStat("unneededCount", "_default_tier"));
        Assert.assertEquals((long)2L, (long)stats.getTieredStat("unneededCount", "tier2"));
    }

    private static void mockDruidServer(ImmutableDruidServer druidServer, ServerType serverType, String name, String tier, long currentSize, long maxSize, List<DataSegment> segments, List<ImmutableDruidDataSource> dataSources) {
        EasyMock.expect((Object)druidServer.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)druidServer.getTier()).andReturn((Object)tier).anyTimes();
        EasyMock.expect((Object)druidServer.getCurrSize()).andReturn((Object)currentSize).anyTimes();
        EasyMock.expect((Object)druidServer.getMaxSize()).andReturn((Object)maxSize).anyTimes();
        ImmutableDruidServerTests.expectSegments(druidServer, segments);
        EasyMock.expect((Object)druidServer.getHost()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)druidServer.getType()).andReturn((Object)serverType).anyTimes();
        EasyMock.expect((Object)druidServer.getDataSources()).andReturn(dataSources).anyTimes();
        if (!segments.isEmpty()) {
            segments.forEach(s -> EasyMock.expect((Object)druidServer.getSegment(s.getId())).andReturn(s).anyTimes());
        }
        EasyMock.expect((Object)druidServer.getSegment((SegmentId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{druidServer});
    }

    private static void mockCoordinator(DruidCoordinator coordinator) {
        coordinator.moveSegment((DruidCoordinatorRuntimeParams)EasyMock.anyObject(), (ImmutableDruidServer)EasyMock.anyObject(), (ImmutableDruidServer)EasyMock.anyObject(), (DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinator});
    }

    private static void mockRuleManager(MetadataRuleManager metadataRuleManager) {
        EasyMock.expect((Object)metadataRuleManager.getRulesWithDefault("datasource1")).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1, (Object)"tier2", (Object)1)))).anyTimes();
        EasyMock.expect((Object)metadataRuleManager.getRulesWithDefault("datasource2")).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1, (Object)"tier2", (Object)1)))).anyTimes();
        EasyMock.expect((Object)metadataRuleManager.getRulesWithDefault("broadcastDatasource")).andReturn(Collections.singletonList(new ForeverBroadcastDistributionRule())).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataRuleManager});
    }
}

