/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ImmutableDruidServerTests;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.ReservoirSegmentSampler;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReservoirSegmentSamplerTest {
    private ImmutableDruidServer druidServer1;
    private ImmutableDruidServer druidServer2;
    private ImmutableDruidServer druidServer3;
    private ImmutableDruidServer druidServer4;
    private ServerHolder holder1;
    private ServerHolder holder2;
    private ServerHolder holder3;
    private ServerHolder holder4;
    private DataSegment segment1;
    private DataSegment segment2;
    private DataSegment segment3;
    private DataSegment segment4;
    List<DataSegment> segments1;
    List<DataSegment> segments2;
    List<DataSegment> segments3;
    List<DataSegment> segments4;
    List<DataSegment> segments;

    @Before
    public void setUp() {
        this.druidServer1 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer2 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer3 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer4 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.holder1 = (ServerHolder)EasyMock.createMock(ServerHolder.class);
        this.holder2 = (ServerHolder)EasyMock.createMock(ServerHolder.class);
        this.holder3 = (ServerHolder)EasyMock.createMock(ServerHolder.class);
        this.holder4 = (ServerHolder)EasyMock.createMock(ServerHolder.class);
        this.segment1 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment2 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment3 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment4 = (DataSegment)EasyMock.createMock(DataSegment.class);
        DateTime start1 = DateTimes.of((String)"2012-01-01");
        DateTime start2 = DateTimes.of((String)"2012-02-01");
        DateTime version = DateTimes.of((String)"2012-03-01");
        this.segment1 = new DataSegment("datasource1", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 11L);
        this.segment2 = new DataSegment("datasource1", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        this.segment3 = new DataSegment("datasource2", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 4L);
        this.segment4 = new DataSegment("datasource2", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 8L);
        this.segments = Lists.newArrayList((Object[])new DataSegment[]{this.segment1, this.segment2, this.segment3, this.segment4});
        this.segments1 = Collections.singletonList(this.segment1);
        this.segments2 = Collections.singletonList(this.segment2);
        this.segments3 = Collections.singletonList(this.segment3);
        this.segments4 = Collections.singletonList(this.segment4);
    }

    @Test
    public void getRandomBalancerSegmentHolderTest() {
        int iterations = 5000;
        EasyMock.expect((Object)this.druidServer1.getType()).andReturn((Object)ServerType.HISTORICAL).times(iterations);
        ImmutableDruidServerTests.expectSegments(this.druidServer1, this.segments1);
        EasyMock.replay((Object[])new Object[]{this.druidServer1});
        EasyMock.expect((Object)this.druidServer2.getType()).andReturn((Object)ServerType.HISTORICAL).times(iterations);
        ImmutableDruidServerTests.expectSegments(this.druidServer2, this.segments2);
        EasyMock.replay((Object[])new Object[]{this.druidServer2});
        EasyMock.expect((Object)this.druidServer3.getType()).andReturn((Object)ServerType.HISTORICAL).times(iterations);
        ImmutableDruidServerTests.expectSegments(this.druidServer3, this.segments3);
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.expect((Object)this.druidServer4.getType()).andReturn((Object)ServerType.HISTORICAL).times(iterations);
        ImmutableDruidServerTests.expectSegments(this.druidServer4, this.segments4);
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        EasyMock.expect((Object)this.holder1.getServer()).andReturn((Object)this.druidServer1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder1});
        EasyMock.expect((Object)this.holder2.getServer()).andReturn((Object)this.druidServer2).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder2});
        EasyMock.expect((Object)this.holder3.getServer()).andReturn((Object)this.druidServer3).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder3});
        EasyMock.expect((Object)this.holder4.getServer()).andReturn((Object)this.druidServer4).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder4});
        ArrayList<ServerHolder> holderList = new ArrayList<ServerHolder>();
        holderList.add(this.holder1);
        holderList.add(this.holder2);
        holderList.add(this.holder3);
        holderList.add(this.holder4);
        HashMap<DataSegment, Integer> segmentCountMap = new HashMap<DataSegment, Integer>();
        for (int i = 0; i < iterations; ++i) {
            segmentCountMap.put(((BalancerSegmentHolder)ReservoirSegmentSampler.getRandomBalancerSegmentHolders(holderList, Collections.emptySet(), (int)1).get(0)).getSegment(), 1);
        }
        for (DataSegment segment : this.segments) {
            Assert.assertEquals((Object)new Integer(1), segmentCountMap.get(segment));
        }
        EasyMock.verify((Object[])new Object[]{this.druidServer1, this.druidServer2, this.druidServer3, this.druidServer4});
        EasyMock.verify((Object[])new Object[]{this.holder1, this.holder2, this.holder3, this.holder4});
    }

    @Test
    public void getRandomBalancerSegmentHolderTestSegmentsToConsiderLimit() {
        int iterations = 5000;
        EasyMock.expect((Object)this.druidServer1.getType()).andReturn((Object)ServerType.HISTORICAL).times(iterations);
        ImmutableDruidServerTests.expectSegments(this.druidServer1, this.segments1);
        EasyMock.replay((Object[])new Object[]{this.druidServer1});
        EasyMock.expect((Object)this.druidServer2.getType()).andReturn((Object)ServerType.HISTORICAL).times(iterations);
        ImmutableDruidServerTests.expectSegments(this.druidServer2, this.segments2);
        EasyMock.replay((Object[])new Object[]{this.druidServer2});
        EasyMock.expect((Object)this.druidServer3.getType()).andReturn((Object)ServerType.HISTORICAL).times(iterations);
        ImmutableDruidServerTests.expectSegments(this.druidServer3, this.segments3);
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        ImmutableDruidServerTests.expectSegments(this.druidServer4, this.segments4);
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        EasyMock.expect((Object)this.holder1.getServer()).andReturn((Object)this.druidServer1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder1});
        EasyMock.expect((Object)this.holder2.getServer()).andReturn((Object)this.druidServer2).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder2});
        EasyMock.expect((Object)this.holder3.getServer()).andReturn((Object)this.druidServer3).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder3});
        EasyMock.expect((Object)this.holder4.getServer()).andReturn((Object)this.druidServer4).times(5000);
        EasyMock.replay((Object[])new Object[]{this.holder4});
        ArrayList<ServerHolder> holderList = new ArrayList<ServerHolder>();
        holderList.add(this.holder1);
        holderList.add(this.holder2);
        holderList.add(this.holder3);
        holderList.add(this.holder4);
        HashMap<DataSegment, Integer> segmentCountMap = new HashMap<DataSegment, Integer>();
        for (int i = 0; i < iterations; ++i) {
            segmentCountMap.put(ReservoirSegmentSampler.getRandomBalancerSegmentHolder(holderList, Collections.emptySet(), (double)75.0).getSegment(), 1);
        }
        for (DataSegment segment : this.segments) {
            if (!segment.equals((Object)this.segment4)) {
                Assert.assertEquals((Object)new Integer(1), segmentCountMap.get(segment));
                continue;
            }
            Assert.assertNull(segmentCountMap.get(segment));
        }
        EasyMock.verify((Object[])new Object[]{this.druidServer1, this.druidServer2, this.druidServer3, this.druidServer4});
        EasyMock.verify((Object[])new Object[]{this.holder1, this.holder2, this.holder3, this.holder4});
    }
}

