/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.client.BatchServerInventoryView;
import org.apache.druid.client.CoordinatorSegmentWatcherConfig;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.ServerView;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.curator.CuratorTestBase;
import org.apache.druid.curator.CuratorUtils;
import org.apache.druid.curator.ZkEnablementConfig;
import org.apache.druid.curator.discovery.NoopServiceAnnouncer;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.CuratorLoadQueuePeon;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroups;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.testing.DeadlockDetectingTimeout;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class CuratorDruidCoordinatorTest
extends CuratorTestBase {
    private DruidCoordinator coordinator;
    private SegmentsMetadataManager segmentsMetadataManager;
    private DataSourcesSnapshot dataSourcesSnapshot;
    private DruidCoordinatorRuntimeParams coordinatorRuntimeParams;
    private ScheduledExecutorFactory scheduledExecutorFactory;
    private ConcurrentMap<String, LoadQueuePeon> loadManagementPeons;
    private LoadQueuePeon sourceLoadQueuePeon;
    private LoadQueuePeon destinationLoadQueuePeon;
    private MetadataRuleManager metadataRuleManager;
    private CountDownLatch leaderAnnouncerLatch;
    private CountDownLatch leaderUnannouncerLatch;
    private PathChildrenCache sourceLoadQueueChildrenCache;
    private PathChildrenCache destinationLoadQueueChildrenCache;
    private DruidCoordinatorConfig druidCoordinatorConfig;
    private ObjectMapper objectMapper;
    private JacksonConfigManager configManager;
    private DruidNode druidNode;
    private static final String SEGPATH = "/druid/segments";
    private static final String SOURCE_LOAD_PATH = "/druid/loadQueue/localhost:1";
    private static final String DESTINATION_LOAD_PATH = "/druid/loadQueue/localhost:2";
    private static final long COORDINATOR_START_DELAY = 1L;
    private static final long COORDINATOR_PERIOD = 100L;
    private BatchServerInventoryView baseView;
    private CoordinatorServerView serverView;
    private CountDownLatch segmentViewInitLatch;
    private volatile CountDownLatch segmentAddedLatch;
    private volatile CountDownLatch segmentRemovedLatch;
    private final ObjectMapper jsonMapper;
    private final ZkPathsConfig zkPathsConfig;
    private ScheduledExecutorService peonExec = Execs.scheduledSingleThreaded((String)"Master-PeonExec--%d");
    private ExecutorService callbackExec = Execs.multiThreaded((int)4, (String)"LoadQueuePeon-callbackexec--%d");
    @Rule
    public final TestRule timeout = new DeadlockDetectingTimeout(60L, TimeUnit.SECONDS);

    public CuratorDruidCoordinatorTest() {
        this.jsonMapper = TestHelper.makeJsonMapper();
        this.zkPathsConfig = new ZkPathsConfig();
    }

    @Before
    public void setUp() throws Exception {
        this.segmentsMetadataManager = (SegmentsMetadataManager)EasyMock.createNiceMock(SegmentsMetadataManager.class);
        this.dataSourcesSnapshot = (DataSourcesSnapshot)EasyMock.createNiceMock(DataSourcesSnapshot.class);
        this.coordinatorRuntimeParams = (DruidCoordinatorRuntimeParams)EasyMock.createNiceMock(DruidCoordinatorRuntimeParams.class);
        this.metadataRuleManager = (MetadataRuleManager)EasyMock.createNiceMock(MetadataRuleManager.class);
        this.configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(CoordinatorDynamicConfig.builder().build())).anyTimes();
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorCompactionConfig>(CoordinatorCompactionConfig.empty())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        this.setupServerAndCurator();
        this.curator.start();
        this.curator.blockUntilConnected();
        this.curator.create().creatingParentsIfNeeded().forPath(SEGPATH);
        this.curator.create().creatingParentsIfNeeded().forPath(SOURCE_LOAD_PATH);
        this.curator.create().creatingParentsIfNeeded().forPath(DESTINATION_LOAD_PATH);
        this.objectMapper = new DefaultObjectMapper();
        this.druidCoordinatorConfig = new TestDruidCoordinatorConfig(new Duration(1L), new Duration(100L), null, null, null, new Duration(100L), null, null, null, null, null, null, null, null, null, null, 10, new Duration((Object)"PT0s"));
        this.sourceLoadQueueChildrenCache = new PathChildrenCache(this.curator, SOURCE_LOAD_PATH, true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_src-%d"));
        this.destinationLoadQueueChildrenCache = new PathChildrenCache(this.curator, DESTINATION_LOAD_PATH, true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_dest-%d"));
        this.sourceLoadQueuePeon = new CuratorLoadQueuePeon(this.curator, SOURCE_LOAD_PATH, this.objectMapper, this.peonExec, this.callbackExec, this.druidCoordinatorConfig);
        this.destinationLoadQueuePeon = new CuratorLoadQueuePeon(this.curator, DESTINATION_LOAD_PATH, this.objectMapper, this.peonExec, this.callbackExec, this.druidCoordinatorConfig);
        this.druidNode = new DruidNode("hey", "what", false, Integer.valueOf(1234), null, true, false);
        this.loadManagementPeons = new ConcurrentHashMap<String, LoadQueuePeon>();
        this.scheduledExecutorFactory = (corePoolSize, nameFormat) -> Executors.newSingleThreadScheduledExecutor();
        this.leaderAnnouncerLatch = new CountDownLatch(1);
        this.leaderUnannouncerLatch = new CountDownLatch(1);
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, this.configManager, this.segmentsMetadataManager, (ServerInventoryView)this.baseView, this.metadataRuleManager, () -> this.curator, (ServiceEmitter)new NoopServiceEmitter(), this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                CuratorDruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                CuratorDruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, null, null, new CoordinatorCustomDutyGroups((Set)ImmutableSet.of()), (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, ZkEnablementConfig.ENABLED);
    }

    @After
    public void tearDown() throws Exception {
        this.baseView.stop();
        this.sourceLoadQueuePeon.stop();
        this.sourceLoadQueueChildrenCache.close();
        this.destinationLoadQueueChildrenCache.close();
        this.tearDownServerAndCurator();
    }

    @Test
    public void testStopDoesntKillPoolItDoesntOwn() throws Exception {
        this.setupView();
        this.sourceLoadQueuePeon.stop();
        Assert.assertFalse((boolean)this.peonExec.isShutdown());
        Assert.assertFalse((boolean)this.callbackExec.isShutdown());
    }

    @Test
    public void testMoveSegment() throws Exception {
        this.segmentViewInitLatch = new CountDownLatch(1);
        this.segmentAddedLatch = new CountDownLatch(4);
        this.segmentRemovedLatch = new CountDownLatch(0);
        CountDownLatch destCountdown = new CountDownLatch(1);
        CountDownLatch srcCountdown = new CountDownLatch(1);
        this.setupView();
        DruidServer source = new DruidServer("localhost:1", "localhost:1", null, 10000000L, ServerType.HISTORICAL, "default_tier", 0);
        DruidServer dest = new DruidServer("localhost:2", "localhost:2", null, 10000000L, ServerType.HISTORICAL, "default_tier", 0);
        this.setupZNodeForServer(source, this.zkPathsConfig, this.jsonMapper);
        this.setupZNodeForServer(dest, this.zkPathsConfig, this.jsonMapper);
        List sourceSegments = Lists.transform((List)ImmutableList.of((Object)Pair.of((Object)"2011-04-01/2011-04-03", (Object)"v1"), (Object)Pair.of((Object)"2011-04-03/2011-04-06", (Object)"v1"), (Object)Pair.of((Object)"2011-04-06/2011-04-09", (Object)"v1")), input -> this.dataSegmentWithIntervalAndVersion((String)input.lhs, (String)input.rhs));
        List destinationSegments = Lists.transform((List)ImmutableList.of((Object)Pair.of((Object)"2011-03-31/2011-04-01", (Object)"v1")), input -> this.dataSegmentWithIntervalAndVersion((String)input.lhs, (String)input.rhs));
        DataSegment segmentToMove = (DataSegment)sourceSegments.get(2);
        ArrayList<String> sourceSegKeys = new ArrayList<String>();
        for (DataSegment segment : sourceSegments) {
            sourceSegKeys.add(this.announceBatchSegmentsForServer(source, (ImmutableSet<DataSegment>)ImmutableSet.of((Object)segment), this.zkPathsConfig, this.jsonMapper));
        }
        for (DataSegment segment : destinationSegments) {
            this.announceBatchSegmentsForServer(dest, (ImmutableSet<DataSegment>)ImmutableSet.of((Object)segment), this.zkPathsConfig, this.jsonMapper);
        }
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentViewInitLatch));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentAddedLatch));
        this.sourceLoadQueueChildrenCache.getListenable().addListener((curatorFramework, event) -> {
            if (event.getType().equals((Object)PathChildrenCacheEvent.Type.INITIALIZED)) {
                srcCountdown.countDown();
            } else if (CuratorUtils.isChildAdded((PathChildrenCacheEvent)event)) {
                this.unannounceSegmentFromBatchForServer(source, segmentToMove, (String)sourceSegKeys.get(2), this.zkPathsConfig);
            }
        });
        this.destinationLoadQueueChildrenCache.getListenable().addListener((curatorFramework, event) -> {
            if (event.getType().equals((Object)PathChildrenCacheEvent.Type.INITIALIZED)) {
                destCountdown.countDown();
            } else if (CuratorUtils.isChildAdded((PathChildrenCacheEvent)event)) {
                this.announceBatchSegmentsForServer(dest, (ImmutableSet<DataSegment>)ImmutableSet.of((Object)segmentToMove), this.zkPathsConfig, this.jsonMapper);
            }
        });
        this.sourceLoadQueueChildrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
        this.destinationLoadQueueChildrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(srcCountdown));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(destCountdown));
        this.loadManagementPeons.put("localhost:1", this.sourceLoadQueuePeon);
        this.loadManagementPeons.put("localhost:2", this.destinationLoadQueuePeon);
        this.segmentRemovedLatch = new CountDownLatch(1);
        this.segmentAddedLatch = new CountDownLatch(1);
        ImmutableDruidDataSource druidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)druidDataSource.getSegment((SegmentId)EasyMock.anyObject(SegmentId.class))).andReturn(sourceSegments.get(2));
        EasyMock.replay((Object[])new Object[]{druidDataSource});
        EasyMock.expect((Object)this.segmentsMetadataManager.getImmutableDataSourceWithUsedSegments(EasyMock.anyString())).andReturn((Object)druidDataSource);
        EasyMock.expect((Object)this.coordinatorRuntimeParams.getDataSourcesSnapshot()).andReturn((Object)this.dataSourcesSnapshot).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager, this.coordinatorRuntimeParams});
        EasyMock.expect((Object)this.dataSourcesSnapshot.getDataSource(EasyMock.anyString())).andReturn((Object)druidDataSource).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.dataSourcesSnapshot});
        this.coordinator.moveSegment(this.coordinatorRuntimeParams, source.toImmutableDruidServer(), dest.toImmutableDruidServer(), (DataSegment)sourceSegments.get(2), null);
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentAddedLatch));
        ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(ZKPaths.makePath((String)DESTINATION_LOAD_PATH, (String)segmentToMove.getId().toString()));
        Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(this.segmentRemovedLatch));
        ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(ZKPaths.makePath((String)SOURCE_LOAD_PATH, (String)segmentToMove.getId().toString()));
        ArrayList servers = new ArrayList(this.serverView.getInventory());
        Assert.assertEquals((long)2L, (long)((DruidServer)servers.get(0)).getTotalSegments());
        Assert.assertEquals((long)2L, (long)((DruidServer)servers.get(1)).getTotalSegments());
    }

    private void setupView() throws Exception {
        this.baseView = new BatchServerInventoryView(this.zkPathsConfig, this.curator, this.jsonMapper, Predicates.alwaysTrue()){

            public void registerSegmentCallback(Executor exec, final ServerView.SegmentCallback callback) {
                super.registerSegmentCallback(exec, new ServerView.SegmentCallback(){

                    public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                        ServerView.CallbackAction res = callback.segmentAdded(server, segment);
                        CuratorDruidCoordinatorTest.this.segmentAddedLatch.countDown();
                        return res;
                    }

                    public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                        ServerView.CallbackAction res = callback.segmentRemoved(server, segment);
                        CuratorDruidCoordinatorTest.this.segmentRemovedLatch.countDown();
                        return res;
                    }

                    public ServerView.CallbackAction segmentViewInitialized() {
                        ServerView.CallbackAction res = callback.segmentViewInitialized();
                        CuratorDruidCoordinatorTest.this.segmentViewInitLatch.countDown();
                        return res;
                    }
                });
            }
        };
        this.serverView = new CoordinatorServerView((ServerInventoryView)this.baseView, new CoordinatorSegmentWatcherConfig());
        this.baseView.start();
        this.sourceLoadQueuePeon.start();
        this.destinationLoadQueuePeon.start();
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, this.configManager, this.segmentsMetadataManager, (ServerInventoryView)this.baseView, this.metadataRuleManager, () -> this.curator, (ServiceEmitter)new NoopServiceEmitter(), this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                CuratorDruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                CuratorDruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, null, null, new CoordinatorCustomDutyGroups((Set)ImmutableSet.of()), (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, ZkEnablementConfig.ENABLED);
    }

    private DataSegment dataSegmentWithIntervalAndVersion(String intervalStr, String version) {
        return DataSegment.builder().dataSource("test_curator_druid_coordinator").interval(Intervals.of((String)intervalStr)).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version(version).dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)NoneShardSpec.instance()).binaryVersion(Integer.valueOf(9)).size(0L).build();
    }

    private static class TestDruidLeaderSelector
    implements DruidLeaderSelector {
        private volatile DruidLeaderSelector.Listener listener;
        private volatile String leader;

        private TestDruidLeaderSelector() {
        }

        public String getCurrentLeader() {
            return this.leader;
        }

        public boolean isLeader() {
            return this.leader != null;
        }

        public int localTerm() {
            return 0;
        }

        public void registerListener(DruidLeaderSelector.Listener listener) {
            this.listener = listener;
            this.leader = "what:1234";
            listener.becomeLeader();
        }

        public void unregisterListener() {
            this.leader = null;
            this.listener.stopBeingLeader();
        }
    }
}

