/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.client.cache.LocalCacheProvider;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.ConcatQueryRunner;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultQueryMetrics;
import org.apache.druid.query.Druids;
import org.apache.druid.query.ForwardingQueryProcessingPool;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.ServerManager;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ServerManagerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ServerManager serverManager;
    private MyQueryRunnerFactory factory;
    private CountDownLatch queryWaitLatch;
    private CountDownLatch queryWaitYieldLatch;
    private CountDownLatch queryNotifyLatch;
    private ExecutorService serverManagerExec;
    private SegmentManager segmentManager;

    @Before
    public void setUp() {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.queryWaitLatch = new CountDownLatch(1);
        this.queryWaitYieldLatch = new CountDownLatch(1);
        this.queryNotifyLatch = new CountDownLatch(1);
        this.factory = new MyQueryRunnerFactory(this.queryWaitLatch, this.queryWaitYieldLatch, this.queryNotifyLatch);
        this.serverManagerExec = Executors.newFixedThreadPool(2);
        this.segmentManager = new SegmentManager(new SegmentLoader(){

            public ReferenceCountingSegment getSegment(DataSegment segment, boolean lazy, SegmentLazyLoadFailCallback SegmentLazyLoadFailCallback2) {
                return ReferenceCountingSegment.wrapSegment((Segment)new SegmentForTesting(MapUtils.getString((Map)segment.getLoadSpec(), (String)"version"), (Interval)segment.getLoadSpec().get("interval")), (ShardSpec)segment.getShardSpec());
            }

            public void cleanup(DataSegment segment) {
            }
        });
        this.serverManager = new ServerManager(new QueryRunnerFactoryConglomerate(){

            public <T, QueryType extends Query<T>> QueryRunnerFactory<T, QueryType> findFactory(QueryType query) {
                if (query instanceof SearchQuery) {
                    return ServerManagerTest.this.factory;
                }
                return null;
            }
        }, (ServiceEmitter)new NoopServiceEmitter(), (QueryProcessingPool)new ForwardingQueryProcessingPool(this.serverManagerExec), (CachePopulator)new ForegroundCachePopulator((ObjectMapper)new DefaultObjectMapper(), new CachePopulatorStats(), -1L), (ObjectMapper)new DefaultObjectMapper(), new LocalCacheProvider().get(), new CacheConfig(), this.segmentManager, (JoinableFactory)NoopJoinableFactory.INSTANCE, new ServerConfig());
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-02"));
        this.loadQueryable("test", "2", Intervals.of((String)"P1d/2011-04-02"));
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-03"));
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-04"));
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-05"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T01"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T02"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T03"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T05"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T06"));
        this.loadQueryable("test2", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.loadQueryable("test2", "1", Intervals.of((String)"P1d/2011-04-02"));
    }

    @Test
    public void testSimpleGet() {
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"P1d/2011-04-01"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)Intervals.of((String)"P1d/2011-04-01"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"P2d/2011-04-02"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)Intervals.of((String)"P1d/2011-04-01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"P1d/2011-04-02"))));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testDelete1() {
        String dataSouce = "test";
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Future future = this.assertQueryable(Granularities.DAY, "test", interval, (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)interval)));
        this.waitForTestVerificationAndCleanup(future);
        this.dropQueryable("test", "2", interval);
        future = this.assertQueryable(Granularities.DAY, "test", interval, (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)interval)));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testDelete2() {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.waitForTestVerificationAndCleanup(future);
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        this.dropQueryable("test", "1", Intervals.of((String)"2011-04-04/2011-04-05"));
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04/2011-04-04T06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T00/2011-04-04T01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T01/2011-04-04T02")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T02/2011-04-04T03")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T04/2011-04-04T05")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T05/2011-04-04T06"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04/2011-04-04T03"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T00/2011-04-04T01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T01/2011-04-04T02")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T02/2011-04-04T03"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04T04/2011-04-04T06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T04/2011-04-04T05")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T05/2011-04-04T06"))));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testReferenceCounting() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.queryNotifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getSegmentReferences().size());
        for (ReferenceCountingSegment referenceCountingSegment : this.factory.getSegmentReferences()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.queryWaitYieldLatch.countDown();
        Assert.assertTrue((this.factory.getAdapters().size() == 1 ? 1 : 0) != 0);
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.queryWaitLatch.countDown();
        future.get();
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertTrue((boolean)segmentForTesting.isClosed());
        }
    }

    @Test
    public void testReferenceCountingWhileQueryExecuting() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.queryNotifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getSegmentReferences().size());
        for (ReferenceCountingSegment referenceCountingSegment : this.factory.getSegmentReferences()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.queryWaitYieldLatch.countDown();
        Assert.assertEquals((long)1L, (long)this.factory.getAdapters().size());
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.queryWaitLatch.countDown();
        future.get();
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertTrue((boolean)segmentForTesting.isClosed());
        }
    }

    @Test
    public void testMultipleDrops() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.queryNotifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getSegmentReferences().size());
        for (ReferenceCountingSegment referenceCountingSegment : this.factory.getSegmentReferences()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.queryWaitYieldLatch.countDown();
        Assert.assertEquals((long)1L, (long)this.factory.getAdapters().size());
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.queryWaitLatch.countDown();
        future.get();
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertTrue((boolean)segmentForTesting.isClosed());
        }
    }

    @Test
    public void testGetQueryRunnerForIntervalsWhenTimelineIsMissingReturningNoopQueryRunner() {
        Interval interval = Intervals.of((String)"0000-01-01/P1D");
        QueryRunner queryRunner = this.serverManager.getQueryRunnerForIntervals((Query)this.searchQuery("unknown_datasource", interval, Granularities.ALL), Collections.singletonList(interval));
        Assert.assertSame(NoopQueryRunner.class, queryRunner.getClass());
    }

    @Test
    public void testGetQueryRunnerForSegmentsWhenTimelineIsMissingReportingMissingSegments() {
        Interval interval = Intervals.of((String)"0000-01-01/P1D");
        SearchQuery query = this.searchQuery("unknown_datasource", interval, Granularities.ALL);
        List<SegmentDescriptor> unknownSegments = Collections.singletonList(new SegmentDescriptor(interval, "unknown_version", 0));
        QueryRunner queryRunner = this.serverManager.getQueryRunnerForSegments((Query)query, unknownSegments);
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        List results = queryRunner.run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertNotNull((Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS));
        Assert.assertEquals(unknownSegments, (Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS));
    }

    @Test
    public void testGetQueryRunnerForSegmentsWhenTimelineEntryIsMissingReportingMissingSegments() {
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        SearchQuery query = this.searchQuery("test", interval, Granularities.ALL);
        List<SegmentDescriptor> unknownSegments = Collections.singletonList(new SegmentDescriptor(interval, "unknown_version", 0));
        QueryRunner queryRunner = this.serverManager.getQueryRunnerForSegments((Query)query, unknownSegments);
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        List results = queryRunner.run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertNotNull((Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS));
        Assert.assertEquals(unknownSegments, (Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS));
    }

    @Test
    public void testGetQueryRunnerForSegmentsWhenTimelinePartitionChunkIsMissingReportingMissingSegments() {
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        int unknownPartitionId = 1000;
        SearchQuery query = this.searchQuery("test", interval, Granularities.ALL);
        List<SegmentDescriptor> unknownSegments = Collections.singletonList(new SegmentDescriptor(interval, "1", 1000));
        QueryRunner queryRunner = this.serverManager.getQueryRunnerForSegments((Query)query, unknownSegments);
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        List results = queryRunner.run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertNotNull((Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS));
        Assert.assertEquals(unknownSegments, (Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS));
    }

    @Test
    public void testGetQueryRunnerForSegmentsWhenSegmentIsClosedReportingMissingSegments() {
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        SearchQuery query = this.searchQuery("test", interval, Granularities.ALL);
        Optional maybeTimeline = this.segmentManager.getTimeline(DataSourceAnalysis.forDataSource((DataSource)query.getDataSource()));
        Assert.assertTrue((boolean)maybeTimeline.isPresent());
        List holders = ((VersionedIntervalTimeline)maybeTimeline.get()).lookup(interval);
        ArrayList<SegmentDescriptor> closedSegments = new ArrayList<SegmentDescriptor>();
        for (TimelineObjectHolder holder : holders) {
            for (PartitionChunk chunk : holder.getObject()) {
                ReferenceCountingSegment segment = (ReferenceCountingSegment)chunk.getObject();
                Assert.assertNotNull((Object)segment.getId());
                closedSegments.add(new SegmentDescriptor(segment.getDataInterval(), segment.getVersion(), segment.getId().getPartitionNum()));
                segment.close();
            }
        }
        QueryRunner queryRunner = this.serverManager.getQueryRunnerForSegments((Query)query, closedSegments);
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        List results = queryRunner.run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
        Assert.assertTrue((boolean)results.isEmpty());
        Assert.assertNotNull((Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS));
        Assert.assertEquals(closedSegments, (Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS));
    }

    @Test
    public void testGetQueryRunnerForSegmentsForUnknownQueryThrowingException() {
        Interval interval = Intervals.of((String)"P1d/2011-04-01");
        List<SegmentDescriptor> descriptors = Collections.singletonList(new SegmentDescriptor(interval, "1", 0));
        this.expectedException.expect(QueryUnsupportedException.class);
        this.expectedException.expectMessage("Unknown query type");
        this.serverManager.getQueryRunnerForSegments((Query)new BaseQuery<Object>((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(descriptors), false, new HashMap()){

            public boolean hasFilters() {
                return false;
            }

            public DimFilter getFilter() {
                return null;
            }

            public String getType() {
                return null;
            }

            public Query<Object> withOverriddenContext(Map<String, Object> contextOverride) {
                return null;
            }

            public Query<Object> withQuerySegmentSpec(QuerySegmentSpec spec) {
                return null;
            }

            public Query<Object> withDataSource(DataSource dataSource) {
                return null;
            }
        }, descriptors);
    }

    private void waitForTestVerificationAndCleanup(Future future) {
        try {
            this.queryNotifyLatch.await(1000L, TimeUnit.MILLISECONDS);
            this.queryWaitYieldLatch.countDown();
            this.queryWaitLatch.countDown();
            future.get();
            this.factory.clearAdapters();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SearchQuery searchQuery(String datasource, Interval interval, Granularity granularity) {
        return Druids.newSearchQueryBuilder().dataSource(datasource).intervals(Collections.singletonList(interval)).granularity(granularity).limit(10000).query("wow").build();
    }

    private Future assertQueryable(Granularity granularity, String dataSource, Interval interval, List<Pair<String, Interval>> expected) {
        final Iterator<Pair<String, Interval>> expectedIter = expected.iterator();
        List<Interval> intervals = Collections.singletonList(interval);
        final SearchQuery query = this.searchQuery(dataSource, interval, granularity);
        final QueryRunner runner = this.serverManager.getQueryRunnerForIntervals((Query)query, intervals);
        return this.serverManagerExec.submit(new Runnable(){

            @Override
            public void run() {
                Sequence seq = runner.run(QueryPlus.wrap((Query)query));
                seq.toList();
                Iterator<SegmentForTesting> adaptersIter = ServerManagerTest.this.factory.getAdapters().iterator();
                while (expectedIter.hasNext() && adaptersIter.hasNext()) {
                    Pair expectedVals = (Pair)expectedIter.next();
                    SegmentForTesting value = adaptersIter.next();
                    Assert.assertEquals((Object)expectedVals.lhs, (Object)value.getVersion());
                    Assert.assertEquals((Object)expectedVals.rhs, (Object)value.getInterval());
                }
                Assert.assertFalse((boolean)expectedIter.hasNext());
                Assert.assertFalse((boolean)adaptersIter.hasNext());
            }
        });
    }

    public void loadQueryable(String dataSource, String version, Interval interval) {
        try {
            this.segmentManager.loadSegment(new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"interval", (Object)interval), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 123L), false, SegmentLazyLoadFailCallback.NOOP);
        }
        catch (SegmentLoadingException e) {
            throw new RuntimeException(e);
        }
    }

    public void dropQueryable(String dataSource, String version, Interval interval) {
        this.segmentManager.dropSegment(new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"interval", (Object)interval), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 123L));
    }

    private static class BlockingSequence<T>
    extends YieldingSequenceBase<T> {
        private final Sequence<T> baseSequence;
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;

        private BlockingSequence(Sequence<T> baseSequence, CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.baseSequence = baseSequence;
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
            this.notifyLatch.countDown();
            try {
                this.waitYieldLatch.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final Yielder baseYielder = this.baseSequence.toYielder(initValue, accumulator);
            return new Yielder<OutType>(){

                public OutType get() {
                    try {
                        waitLatch.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return baseYielder.get();
                }

                public Yielder<OutType> next(OutType initValue) {
                    return baseYielder.next(initValue);
                }

                public boolean isDone() {
                    return baseYielder.isDone();
                }

                public void close() throws IOException {
                    baseYielder.close();
                }
            };
        }
    }

    private static class BlockingQueryRunner<T>
    implements QueryRunner<T> {
        private final QueryRunner<T> runner;
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;

        public BlockingQueryRunner(QueryRunner<T> runner, CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.runner = runner;
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            return new BlockingSequence(this.runner.run(queryPlus, responseContext), this.waitLatch, this.waitYieldLatch, this.notifyLatch);
        }
    }

    private static class SegmentForTesting
    implements Segment {
        private final String version;
        private final Interval interval;
        private final Object lock = new Object();
        private volatile boolean closed = false;

        SegmentForTesting(String version, Interval interval) {
            this.version = version;
            this.interval = interval;
        }

        public String getVersion() {
            return this.version;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public SegmentId getId() {
            return SegmentId.dummy((String)this.version);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public Interval getDataInterval() {
            return this.interval;
        }

        public QueryableIndex asQueryableIndex() {
            throw new UnsupportedOperationException();
        }

        public StorageAdapter asStorageAdapter() {
            return this.makeFakeStorageAdapter(this.interval, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.closed = true;
            }
        }

        private StorageAdapter makeFakeStorageAdapter(final Interval interval, final int cardinality) {
            StorageAdapter adapter = new StorageAdapter(){

                public Interval getInterval() {
                    return interval;
                }

                public int getDimensionCardinality(String column) {
                    return cardinality;
                }

                public DateTime getMinTime() {
                    return interval.getStart();
                }

                public DateTime getMaxTime() {
                    return interval.getEnd();
                }

                public Indexed<String> getAvailableDimensions() {
                    return null;
                }

                public Iterable<String> getAvailableMetrics() {
                    return null;
                }

                @Nullable
                public Comparable getMinValue(String column) {
                    return null;
                }

                @Nullable
                public Comparable getMaxValue(String column) {
                    return null;
                }

                @Nullable
                public ColumnCapabilities getColumnCapabilities(String column) {
                    return null;
                }

                @Nullable
                public String getColumnTypeName(String column) {
                    return null;
                }

                public int getNumRows() {
                    return 0;
                }

                public DateTime getMaxIngestedEventTime() {
                    return null;
                }

                public Metadata getMetadata() {
                    return null;
                }

                public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval2, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
                    return null;
                }
            };
            return adapter;
        }
    }

    public static class NoopQueryToolChest<T, QueryType extends Query<T>>
    extends QueryToolChest<T, QueryType> {
        public QueryRunner<T> mergeResults(QueryRunner<T> runner) {
            return runner;
        }

        public QueryMetrics<Query<?>> makeMetrics(QueryType query) {
            return new DefaultQueryMetrics();
        }

        public Function<T, T> makePreComputeManipulatorFn(QueryType query, MetricManipulationFn fn) {
            return Functions.identity();
        }

        public TypeReference<T> getResultTypeReference() {
            return new TypeReference<T>(){};
        }
    }

    public static class MyQueryRunnerFactory
    implements QueryRunnerFactory<Result<SearchResultValue>, SearchQuery> {
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;
        private List<SegmentForTesting> adapters = new ArrayList<SegmentForTesting>();
        private List<ReferenceCountingSegment> segmentReferences = new ArrayList<ReferenceCountingSegment>();

        public MyQueryRunnerFactory(CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public QueryRunner<Result<SearchResultValue>> createRunner(Segment adapter) {
            if (!(adapter instanceof ReferenceCountingSegment)) {
                throw new IAE("Expected instance of ReferenceCountingSegment, got %s", new Object[]{adapter.getClass()});
            }
            ReferenceCountingSegment segment = (ReferenceCountingSegment)adapter;
            Assert.assertTrue((segment.getNumReferences() > 0 ? 1 : 0) != 0);
            this.segmentReferences.add(segment);
            this.adapters.add((SegmentForTesting)segment.getBaseSegment());
            return new BlockingQueryRunner<Result<SearchResultValue>>((QueryRunner<Result<SearchResultValue>>)new NoopQueryRunner(), this.waitLatch, this.waitYieldLatch, this.notifyLatch);
        }

        public QueryRunner<Result<SearchResultValue>> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<Result<SearchResultValue>>> queryRunners) {
            return new ConcatQueryRunner(Sequences.simple(queryRunners));
        }

        public QueryToolChest<Result<SearchResultValue>, SearchQuery> getToolchest() {
            return new NoopQueryToolChest<Result<SearchResultValue>, SearchQuery>();
        }

        public List<SegmentForTesting> getAdapters() {
            return this.adapters;
        }

        public List<ReferenceCountingSegment> getSegmentReferences() {
            return this.segmentReferences;
        }

        public void clearAdapters() {
            this.adapters.clear();
        }
    }
}

