/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FireHydrantTest
extends InitializedNullHandlingTest {
    private IncrementalIndexSegment incrementalIndexSegment;
    private QueryableIndexSegment queryableIndexSegment;
    private FireHydrant hydrant;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.incrementalIndexSegment = new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), SegmentId.dummy((String)"test"));
        this.queryableIndexSegment = new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"test"));
        this.hydrant = new FireHydrant((Segment)this.incrementalIndexSegment, 0);
    }

    @Test
    public void testGetIncrementedSegmentNotSwapped() {
        Assert.assertEquals((long)0L, (long)this.hydrant.getHydrantSegment().getNumReferences());
        ReferenceCountingSegment segment = this.hydrant.getIncrementedSegment();
        Assert.assertNotNull((Object)segment);
        Assert.assertTrue((segment.getBaseSegment() == this.incrementalIndexSegment ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)segment.getNumReferences());
    }

    @Test
    public void testGetIncrementedSegmentSwapped() {
        ReferenceCountingSegment incrementalSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        this.hydrant.swapSegment((Segment)this.queryableIndexSegment);
        ReferenceCountingSegment segment = this.hydrant.getIncrementedSegment();
        Assert.assertNotNull((Object)segment);
        Assert.assertTrue((segment.getBaseSegment() == this.queryableIndexSegment ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertEquals((long)1L, (long)segment.getNumReferences());
    }

    @Test
    public void testGetIncrementedSegmentClosed() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("segment.close() is called somewhere outside FireHydrant.swapSegment()");
        this.hydrant.getHydrantSegment().close();
        Assert.assertEquals((long)0L, (long)this.hydrant.getHydrantSegment().getNumReferences());
        ReferenceCountingSegment segment = this.hydrant.getIncrementedSegment();
    }

    @Test
    public void testGetAndIncrementSegment() throws IOException {
        ReferenceCountingSegment incrementalSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Pair segmentAndCloseable = this.hydrant.getAndIncrementSegment();
        Assert.assertEquals((long)1L, (long)((ReferenceCountingSegment)segmentAndCloseable.lhs).getNumReferences());
        ((Closeable)segmentAndCloseable.rhs).close();
        Assert.assertEquals((long)0L, (long)((ReferenceCountingSegment)segmentAndCloseable.lhs).getNumReferences());
    }

    @Test
    public void testGetSegmentForQuery() throws IOException {
        ReferenceCountingSegment incrementalSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Optional maybeSegmentAndCloseable = this.hydrant.getSegmentForQuery(Function.identity());
        Assert.assertTrue((boolean)maybeSegmentAndCloseable.isPresent());
        Assert.assertEquals((long)1L, (long)incrementalSegmentReference.getNumReferences());
        Pair segmentAndCloseable = (Pair)maybeSegmentAndCloseable.get();
        ((Closeable)segmentAndCloseable.rhs).close();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
    }

    @Test
    public void testGetSegmentForQuerySwapped() throws IOException {
        ReferenceCountingSegment incrementalSegmentReference = this.hydrant.getHydrantSegment();
        this.hydrant.swapSegment((Segment)this.queryableIndexSegment);
        ReferenceCountingSegment queryableSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertEquals((long)0L, (long)queryableSegmentReference.getNumReferences());
        Optional maybeSegmentAndCloseable = this.hydrant.getSegmentForQuery(Function.identity());
        Assert.assertTrue((boolean)maybeSegmentAndCloseable.isPresent());
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertEquals((long)1L, (long)queryableSegmentReference.getNumReferences());
        Pair segmentAndCloseable = (Pair)maybeSegmentAndCloseable.get();
        ((Closeable)segmentAndCloseable.rhs).close();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertEquals((long)0L, (long)queryableSegmentReference.getNumReferences());
    }

    @Test
    public void testGetSegmentForQueryButNotAbleToAcquireReferences() {
        ReferenceCountingSegment incrementalSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Optional maybeSegmentAndCloseable = this.hydrant.getSegmentForQuery(segmentReference -> new SegmentReference(){

            public Optional<Closeable> acquireReferences() {
                return Optional.empty();
            }

            public SegmentId getId() {
                return FireHydrantTest.this.incrementalIndexSegment.getId();
            }

            public Interval getDataInterval() {
                return FireHydrantTest.this.incrementalIndexSegment.getDataInterval();
            }

            @Nullable
            public QueryableIndex asQueryableIndex() {
                return FireHydrantTest.this.incrementalIndexSegment.asQueryableIndex();
            }

            public StorageAdapter asStorageAdapter() {
                return FireHydrantTest.this.incrementalIndexSegment.asStorageAdapter();
            }

            public void close() {
                FireHydrantTest.this.incrementalIndexSegment.close();
            }
        });
        Assert.assertFalse((boolean)maybeSegmentAndCloseable.isPresent());
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
    }

    @Test
    public void testGetSegmentForQueryButNotAbleToAcquireReferencesSegmentClosed() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("segment.close() is called somewhere outside FireHydrant.swapSegment()");
        ReferenceCountingSegment incrementalSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        incrementalSegmentReference.close();
        Optional maybeSegmentAndCloseable = this.hydrant.getSegmentForQuery(Function.identity());
    }

    @Test
    public void testToStringWhenSwappedWithNull() {
        this.hydrant.swapSegment(null);
        this.hydrant.toString();
    }
}

