/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.LookupDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.druid.segment.TestHelper;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class LookupDimensionSpecTest {
    private static final Map<String, String> STRING_MAP = ImmutableMap.of((Object)"key", (Object)"value", (Object)"key2", (Object)"value2");
    private static LookupExtractor MAP_LOOKUP_EXTRACTOR = new MapLookupExtractor(STRING_MAP, true);
    private static final LookupExtractorFactoryContainerProvider LOOKUP_REF_MANAGER = (LookupExtractorFactoryContainerProvider)EasyMock.createMock(LookupExtractorFactoryContainerProvider.class);
    private final DimensionSpec lookupDimSpec = new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, null, null, Boolean.valueOf(true), null);

    @Parameters
    @Test
    public void testSerDesr(DimensionSpec lookupDimSpec) throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerSubtypes(new NamedType[]{new NamedType(LookupDimensionSpec.class, "lookup")});
        InjectableValues.Std injectableValues = new InjectableValues.Std().addValue(LookupExtractorFactoryContainerProvider.class, (Object)LOOKUP_REF_MANAGER);
        String serLookup = mapper.writeValueAsString((Object)lookupDimSpec);
        Assert.assertEquals((Object)lookupDimSpec, (Object)mapper.readerFor(DimensionSpec.class).with((InjectableValues)injectableValues).readValue(serLookup));
    }

    private Object[] parametersForTestSerDesr() {
        return new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, true, null, null, Boolean.valueOf(true), null), new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, "Missing_value", null, Boolean.valueOf(true), null), new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, null, null, Boolean.valueOf(true), null), new LookupDimensionSpec("dimName", "outputName", null, false, null, "name", Boolean.valueOf(true), LOOKUP_REF_MANAGER)};
    }

    @Test(expected=Exception.class)
    public void testExceptionWhenNameAndLookupNotNull() {
        new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, "replace", "name", Boolean.valueOf(true), null);
    }

    @Test(expected=Exception.class)
    public void testExceptionWhenNameAndLookupNull() {
        new LookupDimensionSpec("dimName", "outputName", null, false, "replace", "", Boolean.valueOf(true), null);
    }

    @Test
    public void testGetDimension() {
        Assert.assertEquals((Object)"dimName", (Object)this.lookupDimSpec.getDimension());
    }

    @Test
    public void testGetOutputName() {
        Assert.assertEquals((Object)"outputName", (Object)this.lookupDimSpec.getOutputName());
    }

    public Object[] parametersForTestApply() {
        return new Object[]{new Object[]{new LookupDimensionSpec("dimName", "outputName", null, true, null, "lookupName", Boolean.valueOf(true), LOOKUP_REF_MANAGER), STRING_MAP}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, true, null, null, Boolean.valueOf(true), null), STRING_MAP}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, null, null, Boolean.valueOf(true), null), TestHelper.createExpectedMap((Object[])new Object[]{"not there", null})}, new Object[]{new LookupDimensionSpec("dimName", "outputName", null, false, null, "lookupName", Boolean.valueOf(true), LOOKUP_REF_MANAGER), TestHelper.createExpectedMap((Object[])new Object[]{"not there", null})}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, "Missing_value", null, Boolean.valueOf(true), null), ImmutableMap.of((Object)"not there", (Object)"Missing_value")}, new Object[]{new LookupDimensionSpec("dimName", "outputName", null, false, "Missing_value", "lookupName", Boolean.valueOf(true), LOOKUP_REF_MANAGER), ImmutableMap.of((Object)"not there", (Object)"Missing_value")}, new Object[]{new LookupDimensionSpec("dimName", "outputName", null, true, null, "lookupName", Boolean.valueOf(true), LOOKUP_REF_MANAGER), ImmutableMap.of((Object)"not there", (Object)"not there")}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, true, null, "", Boolean.valueOf(true), null), ImmutableMap.of((Object)"not there", (Object)"not there")}};
    }

    @Test
    @Parameters
    public void testApply(DimensionSpec dimensionSpec, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Assert.assertEquals((Object)NullHandling.emptyToNullIfNeeded((String)entry.getValue()), (Object)dimensionSpec.getExtractionFn().apply(entry.getKey()));
        }
    }

    public Object[] parametersForTestGetCacheKey() {
        return new Object[]{new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, true, null, null, Boolean.valueOf(true), null), false}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, "Missing_value", null, Boolean.valueOf(true), null), false}, new Object[]{new LookupDimensionSpec("dimName", "outputName2", MAP_LOOKUP_EXTRACTOR, false, null, null, Boolean.valueOf(true), null), false}, new Object[]{new LookupDimensionSpec("dimName2", "outputName2", MAP_LOOKUP_EXTRACTOR, false, null, null, Boolean.valueOf(true), null), false}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, null, null, Boolean.valueOf(true), null), true}, new Object[]{new LookupDimensionSpec("dimName", "outputName", null, false, null, "name", Boolean.valueOf(true), LOOKUP_REF_MANAGER), false}};
    }

    @Test
    @Parameters
    public void testGetCacheKey(DimensionSpec dimensionSpec, boolean expectedResult) {
        Assert.assertEquals((Object)expectedResult, (Object)Arrays.equals(this.lookupDimSpec.getCacheKey(), dimensionSpec.getCacheKey()));
    }

    @Test
    public void testPreservesOrdering() {
        Assert.assertFalse((boolean)this.lookupDimSpec.preservesOrdering());
    }

    @Test
    public void testIsOneToOne() {
        Assert.assertEquals((Object)this.lookupDimSpec.getExtractionFn().getExtractionType(), (Object)ExtractionFn.ExtractionType.ONE_TO_ONE);
    }

    static {
        EasyMock.expect((Object)LOOKUP_REF_MANAGER.get((String)EasyMock.eq((Object)"lookupName"))).andReturn(Optional.of(new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)new MapLookupExtractorFactory(STRING_MAP, false)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{LOOKUP_REF_MANAGER});
    }
}

