/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataConnectorTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
    }

    @Test
    public void testCreateTables() {
        final ArrayList<String> tables = new ArrayList<String>();
        String entryType = this.tablesConfig.getTaskEntryType();
        tables.add(this.tablesConfig.getConfigTable());
        tables.add(this.tablesConfig.getSegmentsTable());
        tables.add(this.tablesConfig.getRulesTable());
        tables.add(this.tablesConfig.getLockTable(entryType));
        tables.add(this.tablesConfig.getLogTable(entryType));
        tables.add(this.tablesConfig.getEntryTable(entryType));
        tables.add(this.tablesConfig.getAuditTable());
        tables.add(this.tablesConfig.getSupervisorTable());
        this.connector.createSegmentTable();
        this.connector.createConfigTable();
        this.connector.createRulesTable();
        this.connector.createTaskTables();
        this.connector.createAuditTable();
        this.connector.createSupervisorsTable();
        this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                for (String table : tables) {
                    Assert.assertTrue((String)StringUtils.format((String)"table %s was not created!", (Object[])new Object[]{table}), (boolean)SQLMetadataConnectorTest.this.connector.tableExists(handle, table));
                }
                return null;
            }
        });
        for (String table : tables) {
            this.dropTable(table);
        }
    }

    @Test
    public void testInsertOrUpdate() {
        String tableName = "test";
        this.connector.createConfigTable("test");
        Assert.assertNull((Object)this.connector.lookup("test", "name", "payload", "emperor"));
        this.connector.insertOrUpdate("test", "name", "payload", "emperor", StringUtils.toUtf8((String)"penguin"));
        Assert.assertArrayEquals((byte[])StringUtils.toUtf8((String)"penguin"), (byte[])this.connector.lookup("test", "name", "payload", "emperor"));
        this.connector.insertOrUpdate("test", "name", "payload", "emperor", StringUtils.toUtf8((String)"penguin chick"));
        Assert.assertArrayEquals((byte[])StringUtils.toUtf8((String)"penguin chick"), (byte[])this.connector.lookup("test", "name", "payload", "emperor"));
        this.dropTable("test");
    }

    private void dropTable(final String tableName) {
        this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute();
                return null;
            }
        });
    }

    private MetadataStorageConnectorConfig getDbcpPropertiesFile(boolean createTables, String host, int port, String connectURI, String user, String pwdString, String pwd) throws Exception {
        return (MetadataStorageConnectorConfig)JSON_MAPPER.readValue("{\"createTables\": \"" + createTables + "\",\"host\": \"" + host + "\",\"port\": \"" + port + "\",\"connectURI\": \"" + connectURI + "\",\"user\": \"" + user + "\",\"password\": " + pwdString + ",\"dbcp\": {\n  \"maxConnLifetimeMillis\" : 1200000,\n  \"defaultQueryTimeout\" : \"30000\"\n}}", MetadataStorageConnectorConfig.class);
    }

    @Test
    public void testBasicDataSourceCreation() throws Exception {
        MetadataStorageConnectorConfig config = this.getDbcpPropertiesFile(true, "host", 1234, "connectURI", "user", "{\"type\":\"default\",\"password\":\"nothing\"}", "nothing");
        TestSQLMetadataConnector testSQLMetadataConnector = new TestSQLMetadataConnector((Supplier<MetadataStorageConnectorConfig>)Suppliers.ofInstance((Object)config), (Supplier<MetadataStorageTablesConfig>)Suppliers.ofInstance((Object)this.tablesConfig));
        BasicDataSource dataSource = testSQLMetadataConnector.getDatasource();
        Assert.assertEquals((long)dataSource.getMaxConnLifetimeMillis(), (long)1200000L);
        Assert.assertEquals((long)dataSource.getDefaultQueryTimeout().intValue(), (long)30000L);
    }

    static class TestSQLMetadataConnector
    extends SQLMetadataConnector {
        public TestSQLMetadataConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> tablesConfigSupplier) {
            super(config, tablesConfigSupplier);
        }

        public String getSerialType() {
            return null;
        }

        public int getStreamingFetchSize() {
            return 0;
        }

        public String getQuoteString() {
            return null;
        }

        public boolean tableExists(Handle handle, String tableName) {
            return false;
        }

        public DBI getDBI() {
            return null;
        }

        protected BasicDataSource getDatasource() {
            return super.getDatasource();
        }
    }
}

