/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.guice.JsonConfigTesterBase;
import org.junit.Assert;
import org.junit.Test;

public final class JsonConfigTesterBaseTest
extends JsonConfigTesterBase<Sample> {
    @Test
    public void defaultTestPropertiesForSample() {
        Assert.assertEquals((Object)"0", (Object)this.testProperties.getProperty("druid.test.prefix.primitiveInt"));
        Assert.assertEquals((Object)"false", (Object)this.testProperties.getProperty("druid.test.prefix.primitiveBoolean"));
        Assert.assertTrue((!this.testProperties.getProperty("druid.test.prefix.text").isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"[]", (Object)this.testProperties.getProperty("druid.test.prefix.list"));
        Assert.assertEquals((Object)"[]", (Object)this.testProperties.getProperty("druid.test.prefix.set"));
        Assert.assertEquals((Object)"{}", (Object)this.testProperties.getProperty("druid.test.prefix.map"));
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Assert.assertEquals((Object)entry.getValue(), (Object)this.testProperties.get(entry.getKey()));
        }
    }

    @Test
    public void injectFieldValues() {
        this.propertyValues.put(JsonConfigTesterBaseTest.getPropertyKey("primitiveInt"), "1");
        this.propertyValues.put(JsonConfigTesterBaseTest.getPropertyKey("primitiveBoolean"), "true");
        this.propertyValues.put(JsonConfigTesterBaseTest.getPropertyKey("text"), "foo");
        this.propertyValues.put(JsonConfigTesterBaseTest.getPropertyKey("list"), "[\"one\",\"two\"]");
        this.propertyValues.put(JsonConfigTesterBaseTest.getPropertyKey("set"), "[\"three\",\"four\"]");
        this.propertyValues.put(JsonConfigTesterBaseTest.getPropertyKey("map"), "{\"k1\": \"v1\", \"k2\": \"v2\"}");
        this.testProperties.putAll((Map<?, ?>)this.propertyValues);
        this.configProvider.inject(this.testProperties, this.configurator);
        Sample results = (Sample)this.configProvider.get().get();
        Assert.assertEquals((long)1L, (long)results.getPrimitiveInt());
        Assert.assertTrue((boolean)results.getPrimitiveBoolean());
        Assert.assertEquals((Object)"foo", (Object)results.getText());
        List<String> list = results.getList();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"one", (Object)list.get(0));
        Assert.assertEquals((Object)"two", (Object)list.get(1));
        Set<String> set = results.getSet();
        Assert.assertEquals((long)2L, (long)set.size());
        Assert.assertTrue((boolean)set.contains("three"));
        Assert.assertTrue((boolean)set.contains("four"));
        Map<String, String> map = results.getMap();
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"v1", (Object)map.get("k1"));
        Assert.assertEquals((Object)"v2", (Object)map.get("k2"));
    }

    public static class Sample {
        @JsonProperty
        private int primitiveInt;
        @JsonProperty
        private boolean primitiveBoolean;
        @JsonProperty
        private String text;
        @JsonProperty
        private List<String> list;
        @JsonProperty
        private Set<String> set;
        @JsonProperty
        private Map<String, String> map;

        public int getPrimitiveInt() {
            return this.primitiveInt;
        }

        public boolean getPrimitiveBoolean() {
            return this.primitiveBoolean;
        }

        public String getText() {
            return this.text;
        }

        public List<String> getList() {
            return this.list;
        }

        public Set<String> getSet() {
            return this.set;
        }

        public Map<String, String> getMap() {
            return this.map;
        }
    }
}

