/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.Objects;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class ServerHolder
implements Comparable<ServerHolder> {
    private static final Logger log = new Logger(ServerHolder.class);
    private final ImmutableDruidServer server;
    private final LoadQueuePeon peon;
    private final boolean isDecommissioning;

    public ServerHolder(ImmutableDruidServer server, LoadQueuePeon peon) {
        this(server, peon, false);
    }

    public ServerHolder(ImmutableDruidServer server, LoadQueuePeon peon, boolean isDecommissioning) {
        this.server = server;
        this.peon = peon;
        this.isDecommissioning = isDecommissioning;
    }

    public ImmutableDruidServer getServer() {
        return this.server;
    }

    public LoadQueuePeon getPeon() {
        return this.peon;
    }

    public long getMaxSize() {
        return this.server.getMaxSize();
    }

    public long getCurrServerSize() {
        return this.server.getCurrSize();
    }

    public long getLoadQueueSize() {
        return this.peon.getLoadQueueSize();
    }

    public long getSizeUsed() {
        return this.getCurrServerSize() + this.getLoadQueueSize();
    }

    public double getPercentUsed() {
        return 100.0 * (double)this.getSizeUsed() / (double)this.getMaxSize();
    }

    public boolean isDecommissioning() {
        return this.isDecommissioning;
    }

    public long getAvailableSize() {
        long maxSize = this.getMaxSize();
        long sizeUsed = this.getSizeUsed();
        long availableSize = maxSize - sizeUsed;
        log.debug("Server[%s], MaxSize[%,d], CurrSize[%,d], QueueSize[%,d], SizeUsed[%,d], AvailableSize[%,d]", new Object[]{this.server.getName(), maxSize, this.getCurrServerSize(), this.getLoadQueueSize(), sizeUsed, availableSize});
        return availableSize;
    }

    public boolean isServingSegment(DataSegment segment) {
        return this.isServingSegment(segment.getId());
    }

    public boolean isLoadingSegment(DataSegment segment) {
        return this.peon.getSegmentsToLoad().contains(segment);
    }

    public boolean isDroppingSegment(DataSegment segment) {
        return this.peon.getSegmentsToDrop().contains(segment);
    }

    public int getNumberOfSegmentsInQueue() {
        return this.peon.getNumberOfSegmentsInQueue();
    }

    public boolean isServingSegment(SegmentId segmentId) {
        return this.server.getSegment(segmentId) != null;
    }

    @Override
    public int compareTo(ServerHolder serverHolder) {
        int result = Long.compare(this.getAvailableSize(), serverHolder.getAvailableSize());
        if (result != 0) {
            return result;
        }
        result = this.server.getHost().compareTo(serverHolder.server.getHost());
        if (result != 0) {
            return result;
        }
        result = this.server.getTier().compareTo(serverHolder.server.getTier());
        if (result != 0) {
            return result;
        }
        return this.server.getType().compareTo(serverHolder.server.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerHolder that = (ServerHolder)o;
        if (!this.server.getHost().equals(that.server.getHost())) {
            return false;
        }
        if (!this.server.getTier().equals(that.getServer().getTier())) {
            return false;
        }
        return this.server.getType().equals((Object)that.getServer().getType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.server.getHost(), this.server.getTier(), this.server.getType()});
    }
}

