/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;

@LazySingleton
public class QueryLifecycleFactory {
    private final QueryToolChestWarehouse warehouse;
    private final QuerySegmentWalker texasRanger;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final AuthorizerMapper authorizerMapper;
    private final DefaultQueryConfig defaultQueryConfig;

    @Inject
    public QueryLifecycleFactory(QueryToolChestWarehouse warehouse, QuerySegmentWalker texasRanger, GenericQueryMetricsFactory queryMetricsFactory, ServiceEmitter emitter, RequestLogger requestLogger, AuthConfig authConfig, AuthorizerMapper authorizerMapper, Supplier<DefaultQueryConfig> queryConfigSupplier) {
        this.warehouse = warehouse;
        this.texasRanger = texasRanger;
        this.queryMetricsFactory = queryMetricsFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.authorizerMapper = authorizerMapper;
        this.defaultQueryConfig = (DefaultQueryConfig)queryConfigSupplier.get();
    }

    public QueryLifecycle factorize() {
        return new QueryLifecycle(this.warehouse, this.texasRanger, this.queryMetricsFactory, this.emitter, this.requestLogger, this.authorizerMapper, this.defaultQueryConfig, System.currentTimeMillis(), System.nanoTime());
    }
}

