/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;

public class SegmentWithState {
    private final SegmentIdWithShardSpec segmentIdentifier;
    private SegmentState state;
    @Nullable
    private DataSegment dataSegment;

    static SegmentWithState newSegment(SegmentIdWithShardSpec segmentIdentifier) {
        return new SegmentWithState(segmentIdentifier, SegmentState.APPENDING, null);
    }

    static SegmentWithState newSegment(SegmentIdWithShardSpec segmentIdentifier, SegmentState state) {
        return new SegmentWithState(segmentIdentifier, state, null);
    }

    @JsonCreator
    public SegmentWithState(@JsonProperty(value="segmentIdentifier") SegmentIdWithShardSpec segmentIdentifier, @JsonProperty(value="state") SegmentState state, @JsonProperty(value="dataSegment") @Nullable DataSegment dataSegment) {
        this.segmentIdentifier = segmentIdentifier;
        this.state = state;
        this.dataSegment = dataSegment;
    }

    public void setState(SegmentState state) {
        this.state = state;
    }

    public void finishAppending() {
        SegmentWithState.checkStateTransition(this.state, SegmentState.APPENDING, SegmentState.APPEND_FINISHED);
        this.state = SegmentState.APPEND_FINISHED;
    }

    public void pushAndDrop(DataSegment dataSegment) {
        SegmentWithState.checkStateTransition(this.state, SegmentState.APPENDING, SegmentState.PUSHED_AND_DROPPED);
        this.state = SegmentState.PUSHED_AND_DROPPED;
        this.dataSegment = dataSegment;
    }

    @JsonProperty
    public SegmentIdWithShardSpec getSegmentIdentifier() {
        return this.segmentIdentifier;
    }

    @JsonProperty
    public SegmentState getState() {
        return this.state;
    }

    @JsonProperty
    @Nullable
    public DataSegment getDataSegment() {
        return this.dataSegment;
    }

    private static void checkStateTransition(SegmentState actualFrom, SegmentState expectedFrom, SegmentState to) {
        Preconditions.checkState((actualFrom == expectedFrom ? 1 : 0) != 0, (String)"Wrong state transition from [%s] to [%s]", (Object[])new Object[]{actualFrom, to});
    }

    public String toString() {
        return "SegmentWithState{segmentIdentifier=" + this.segmentIdentifier + ", state=" + (Object)((Object)this.state) + '}';
    }

    public static enum SegmentState {
        APPENDING,
        APPEND_FINISHED,
        PUSHED_AND_DROPPED;


        @JsonCreator
        public static SegmentState fromString(@JsonProperty String name) {
            if ("ACTIVE".equalsIgnoreCase(name)) {
                return APPENDING;
            }
            if ("INACTIVE".equalsIgnoreCase(name)) {
                return APPEND_FINISHED;
            }
            return SegmentState.valueOf(name);
        }
    }
}

