/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorDriverAddResult;
import org.apache.druid.segment.realtime.appenderator.AppenderatorDriverSegmentLockHelper;
import org.apache.druid.segment.realtime.appenderator.BaseAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentWithState;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.druid.timeline.DataSegment;

public class BatchAppenderatorDriver
extends BaseAppenderatorDriver {
    public BatchAppenderatorDriver(Appenderator appenderator, SegmentAllocator segmentAllocator, UsedSegmentChecker usedSegmentChecker, DataSegmentKiller dataSegmentKiller) {
        super(appenderator, segmentAllocator, usedSegmentChecker, dataSegmentKiller);
    }

    @Nullable
    public Object startJob() {
        return this.startJob(AppenderatorDriverSegmentLockHelper.NOOP);
    }

    @Override
    @Nullable
    public Object startJob(AppenderatorDriverSegmentLockHelper lockHelper) {
        Object metadata = this.appenderator.startJob();
        if (metadata != null) {
            throw new ISE("Metadata should be null because BatchAppenderatorDriver never persists it", new Object[0]);
        }
        return null;
    }

    public AppenderatorDriverAddResult add(InputRow row, String sequenceName) throws IOException {
        return this.append(row, sequenceName, null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentsAndCommitMetadata pushAllAndClear(long pushAndClearTimeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        ImmutableList sequences;
        Map map = this.segments;
        synchronized (map) {
            sequences = ImmutableList.copyOf(this.segments.keySet());
        }
        return this.pushAndClear((Collection<String>)sequences, pushAndClearTimeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentsAndCommitMetadata pushAndClear(Collection<String> sequenceNames, long pushAndClearTimeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        Set<SegmentIdWithShardSpec> requestedSegmentIdsForSequences = this.getAppendingSegments(sequenceNames);
        ListenableFuture future = Futures.transform(this.pushInBackground(null, requestedSegmentIdsForSequences, false), this::dropInBackground);
        SegmentsAndCommitMetadata segmentsAndCommitMetadata = pushAndClearTimeoutMs == 0L ? (SegmentsAndCommitMetadata)future.get() : (SegmentsAndCommitMetadata)future.get(pushAndClearTimeoutMs, TimeUnit.MILLISECONDS);
        Map pushedSegmentIdToSegmentMap = segmentsAndCommitMetadata.getSegments().stream().collect(Collectors.toMap(SegmentIdWithShardSpec::fromDataSegment, Function.identity()));
        if (!pushedSegmentIdToSegmentMap.keySet().equals(requestedSegmentIdsForSequences)) {
            throw new ISE("Pushed segments[%s] are different from the requested ones[%s]", new Object[]{pushedSegmentIdToSegmentMap.keySet(), requestedSegmentIdsForSequences});
        }
        Map map = this.segments;
        synchronized (map) {
            for (String sequenceName : sequenceNames) {
                BaseAppenderatorDriver.SegmentsForSequence segmentsForSequence = (BaseAppenderatorDriver.SegmentsForSequence)this.segments.get(sequenceName);
                if (segmentsForSequence == null) {
                    throw new ISE("Can't find segmentsForSequence for sequence[%s]", new Object[]{sequenceName});
                }
                segmentsForSequence.getAllSegmentsOfInterval().forEach(segmentsOfInterval -> {
                    SegmentWithState appendingSegment = segmentsOfInterval.getAppendingSegment();
                    if (appendingSegment != null) {
                        DataSegment pushedSegment = (DataSegment)pushedSegmentIdToSegmentMap.get(appendingSegment.getSegmentIdentifier());
                        if (pushedSegment == null) {
                            throw new ISE("Can't find pushedSegments for segment[%s]", new Object[]{appendingSegment.getSegmentIdentifier()});
                        }
                        segmentsOfInterval.finishAppendingToCurrentActiveSegment(segmentWithState -> segmentWithState.pushAndDrop(pushedSegment));
                    }
                });
            }
        }
        return segmentsAndCommitMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<SegmentsAndCommitMetadata> publishAll(@Nullable Set<DataSegment> segmentsToBeOverwritten, @Nullable Set<DataSegment> segmentsToBeDropped, TransactionalSegmentPublisher publisher, Function<Set<DataSegment>, Set<DataSegment>> outputSegmentsAnnotateFunction) {
        ImmutableMap snapshot;
        Map map = this.segments;
        synchronized (map) {
            snapshot = ImmutableMap.copyOf((Map)this.segments);
        }
        return this.publishInBackground(segmentsToBeOverwritten, segmentsToBeDropped, new SegmentsAndCommitMetadata(snapshot.values().stream().flatMap(BaseAppenderatorDriver.SegmentsForSequence::allSegmentStateStream).map(segmentWithState -> (DataSegment)Preconditions.checkNotNull((Object)segmentWithState.getDataSegment(), (String)"dataSegment for segmentId[%s]", (Object[])new Object[]{segmentWithState.getSegmentIdentifier()})).collect(Collectors.toList()), null), publisher, outputSegmentsAnnotateFunction);
    }
}

