/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.query.dimension.LookupDimensionSpec;
import org.apache.druid.query.expression.LookupExprMacro;
import org.apache.druid.query.lookup.LookupConfig;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;

public class LookupSerdeModule
implements DruidModule {
    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new SimpleModule("DruidLookupModule").registerSubtypes(new Class[]{MapLookupExtractorFactory.class}), (Object)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(LookupDimensionSpec.class, "lookup"), new NamedType(RegisteredLookupExtractionFn.class, "registeredLookup")}));
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.lookup", LookupConfig.class);
        binder.bind(LookupExtractorFactoryContainerProvider.class).to(NoopLookupExtractorFactoryContainerProvider.class);
        ExpressionModule.addExprMacro(binder, LookupExprMacro.class);
    }

    private static class NoopLookupExtractorFactoryContainerProvider
    implements LookupExtractorFactoryContainerProvider {
        private NoopLookupExtractorFactoryContainerProvider() {
        }

        public Set<String> getAllLookupNames() {
            return Collections.emptySet();
        }

        public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
            return Optional.empty();
        }
    }
}

