/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.server.DruidNode;

public class DiscoveryDruidNode {
    private final DruidNode druidNode;
    private final NodeRole nodeRole;
    private final Map<String, DruidService> services = new HashMap<String, DruidService>();

    @JsonCreator
    public DiscoveryDruidNode(@JsonProperty(value="druidNode") DruidNode druidNode, @JsonProperty(value="nodeType") NodeRole nodeRole, @JsonProperty(value="services") Map<String, DruidService> services) {
        this.druidNode = druidNode;
        this.nodeRole = nodeRole;
        if (services != null && !services.isEmpty()) {
            this.services.putAll(services);
        }
    }

    @JsonProperty
    public Map<String, DruidService> getServices() {
        return this.services;
    }

    @JsonProperty(value="nodeType")
    public NodeRole getNodeRole() {
        return this.nodeRole;
    }

    @JsonProperty
    public DruidNode getDruidNode() {
        return this.druidNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryDruidNode that = (DiscoveryDruidNode)o;
        return Objects.equals(this.druidNode, that.druidNode) && Objects.equals(this.nodeRole, that.nodeRole) && Objects.equals(this.services, that.services);
    }

    public int hashCode() {
        return Objects.hash(this.druidNode, this.nodeRole, this.services);
    }

    public String toString() {
        return "DiscoveryDruidNode{druidNode=" + this.druidNode + ", nodeRole='" + this.nodeRole + '\'' + ", services=" + this.services + '}';
    }
}

