/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.java.util.common.granularity.Granularity;

public class ClientCompactionTaskGranularitySpec {
    private final Granularity segmentGranularity;
    private final Granularity queryGranularity;

    @JsonCreator
    public ClientCompactionTaskGranularitySpec(@JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="queryGranularity") Granularity queryGranularity) {
        this.queryGranularity = queryGranularity;
        this.segmentGranularity = segmentGranularity;
    }

    @JsonProperty
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @JsonProperty
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    public ClientCompactionTaskGranularitySpec withSegmentGranularity(Granularity segmentGranularity) {
        return new ClientCompactionTaskGranularitySpec(segmentGranularity, this.queryGranularity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionTaskGranularitySpec that = (ClientCompactionTaskGranularitySpec)o;
        return Objects.equals(this.segmentGranularity, that.segmentGranularity) && Objects.equals(this.queryGranularity, that.queryGranularity);
    }

    public int hashCode() {
        return Objects.hash(this.segmentGranularity, this.queryGranularity);
    }

    public String toString() {
        return "ClientCompactionTaskGranularitySpec{segmentGranularity=" + this.segmentGranularity + ", queryGranularity=" + this.queryGranularity + '}';
    }
}

