/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;

public class ForegroundCachePopulator
implements CachePopulator {
    private static final Logger log = new Logger(ForegroundCachePopulator.class);
    private final ObjectMapper objectMapper;
    private final CachePopulatorStats cachePopulatorStats;
    private final long maxEntrySize;

    public ForegroundCachePopulator(ObjectMapper objectMapper, CachePopulatorStats cachePopulatorStats, long maxEntrySize) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper, (Object)"objectMapper");
        this.cachePopulatorStats = (CachePopulatorStats)Preconditions.checkNotNull((Object)cachePopulatorStats, (Object)"cachePopulatorStats");
        this.maxEntrySize = maxEntrySize;
    }

    @Override
    public <T, CacheType> Sequence<T> wrap(Sequence<T> sequence, Function<T, CacheType> cacheFn, final Cache cache, final Cache.NamedKey cacheKey) {
        JsonGenerator jsonGenerator;
        final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        final MutableBoolean tooBig = new MutableBoolean(false);
        try {
            jsonGenerator = this.objectMapper.getFactory().createGenerator((OutputStream)bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Sequences.wrap((Sequence)Sequences.map(sequence, input -> {
            if (!tooBig.isTrue()) {
                try {
                    jsonGenerator.writeObject(cacheFn.apply(input));
                    if (this.maxEntrySize > 0L && (long)bytes.size() > this.maxEntrySize) {
                        tooBig.setValue(true);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return input;
        }), (SequenceWrapper)new SequenceWrapper(){

            public void after(boolean isDone, Throwable thrown) throws Exception {
                jsonGenerator.close();
                if (isDone) {
                    if (tooBig.isTrue() || ForegroundCachePopulator.this.maxEntrySize > 0L && (long)bytes.size() > ForegroundCachePopulator.this.maxEntrySize) {
                        ForegroundCachePopulator.this.cachePopulatorStats.incrementOversized();
                        return;
                    }
                    try {
                        cache.put(cacheKey, bytes.toByteArray());
                        ForegroundCachePopulator.this.cachePopulatorStats.incrementOk();
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Unable to write to cache", new Object[0]);
                        ForegroundCachePopulator.this.cachePopulatorStats.incrementError();
                    }
                }
            }
        });
    }
}

