/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.router;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.router.TieredBrokerConfig;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Duration;

@ManageLifecycle
public class CoordinatorRuleManager {
    private static final Logger LOG = new Logger(CoordinatorRuleManager.class);
    private static final TypeReference<Map<String, List<Rule>>> TYPE_REFERENCE = new TypeReference<Map<String, List<Rule>>>(){};
    private final ObjectMapper jsonMapper;
    private final Supplier<TieredBrokerConfig> config;
    private final AtomicReference<Map<String, List<Rule>>> rules;
    private final DruidLeaderClient druidLeaderClient;
    private final Object lock = new Object();
    private volatile boolean started = false;
    @GuardedBy(value="lock")
    private ScheduledExecutorService exec;

    @Inject
    public CoordinatorRuleManager(@Json ObjectMapper jsonMapper, Supplier<TieredBrokerConfig> config, @Coordinator DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.druidLeaderClient = druidLeaderClient;
        this.rules = new AtomicReference(Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.exec = Execs.scheduledSingleThreaded((String)"CoordinatorRuleManager-Exec--%d");
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(0L), (Duration)((TieredBrokerConfig)this.config.get()).getPollPeriod().toStandardDuration(), this::poll);
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.rules.set(Collections.emptyMap());
            this.started = false;
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void poll() {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/rules"));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while polling rules, status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            Map map = (Map)this.jsonMapper.readValue(response.getContent(), TYPE_REFERENCE);
            HashMap immutableMapBuilder = Maps.newHashMapWithExpectedSize((int)map.size());
            map.forEach((k, list) -> immutableMapBuilder.put(k, Collections.unmodifiableList(list)));
            this.rules.set(Collections.unmodifiableMap(immutableMapBuilder));
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Exception while polling for rules", new Object[0]);
        }
    }

    public List<Rule> getRulesWithDefault(String dataSource) {
        List<Rule> defaultRules;
        ArrayList<Rule> rulesWithDefault = new ArrayList<Rule>();
        Map<String, List<Rule>> theRules = this.rules.get();
        List<Rule> dataSourceRules = theRules.get(dataSource);
        if (dataSourceRules != null) {
            rulesWithDefault.addAll(dataSourceRules);
        }
        if ((defaultRules = theRules.get(((TieredBrokerConfig)this.config.get()).getDefaultRule())) != null) {
            rulesWithDefault.addAll(defaultRules);
        }
        return rulesWithDefault;
    }

    @VisibleForTesting
    Map<String, List<Rule>> getRules() {
        return this.rules.get();
    }
}

