/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.http.security.ConfigResourceFilter;

@Path(value="/druid/coordinator/v1/config/compaction")
@ResourceFilters(value={ConfigResourceFilter.class})
public class CoordinatorCompactionConfigsResource {
    private final JacksonConfigManager manager;

    @Inject
    public CoordinatorCompactionConfigsResource(JacksonConfigManager manager) {
        this.manager = manager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCompactionConfig() {
        return Response.ok((Object)CoordinatorCompactionConfig.current(this.manager)).build();
    }

    @POST
    @Path(value="/taskslots")
    @Consumes(value={"application/json"})
    public Response setCompactionTaskLimit(@QueryParam(value="ratio") Double compactionTaskSlotRatio, @QueryParam(value="max") Integer maxCompactionTaskSlots, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        CoordinatorCompactionConfig current = CoordinatorCompactionConfig.current(this.manager);
        CoordinatorCompactionConfig newCompactionConfig = CoordinatorCompactionConfig.from(current, compactionTaskSlotRatio, maxCompactionTaskSlots);
        ConfigManager.SetResult setResult = this.manager.set("coordinator.compaction.config", (Object)newCompactionConfig, new AuditInfo(author, comment, req.getRemoteAddr()));
        if (setResult.isOk()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)setResult.getException())).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addOrUpdateCompactionConfig(DataSourceCompactionConfig newConfig, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        CoordinatorCompactionConfig current = CoordinatorCompactionConfig.current(this.manager);
        Map newConfigs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        newConfigs.put(newConfig.getDataSource(), newConfig);
        CoordinatorCompactionConfig newCompactionConfig = CoordinatorCompactionConfig.from(current, (List<DataSourceCompactionConfig>)ImmutableList.copyOf(newConfigs.values()));
        ConfigManager.SetResult setResult = this.manager.set("coordinator.compaction.config", (Object)newCompactionConfig, new AuditInfo(author, comment, req.getRemoteAddr()));
        if (setResult.isOk()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="/{dataSource}")
    @Produces(value={"application/json"})
    public Response getCompactionConfig(@PathParam(value="dataSource") String dataSource) {
        CoordinatorCompactionConfig current = CoordinatorCompactionConfig.current(this.manager);
        Map configs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        DataSourceCompactionConfig config = (DataSourceCompactionConfig)configs.get(dataSource);
        if (config == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)config).build();
    }

    @DELETE
    @Path(value="/{dataSource}")
    @Produces(value={"application/json"})
    public Response deleteCompactionConfig(@PathParam(value="dataSource") String dataSource, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        CoordinatorCompactionConfig current = CoordinatorCompactionConfig.current(this.manager);
        Map configs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        DataSourceCompactionConfig config = (DataSourceCompactionConfig)configs.remove(dataSource);
        if (config == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ConfigManager.SetResult setResult = this.manager.set("coordinator.compaction.config", (Object)CoordinatorCompactionConfig.from(current, (List<DataSourceCompactionConfig>)ImmutableList.copyOf(configs.values())), new AuditInfo(author, comment, req.getRemoteAddr()));
        if (setResult.isOk()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }
}

