/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid/coordinator/v1/compaction")
public class CompactionResource {
    private final DruidCoordinator coordinator;

    @Inject
    public CompactionResource(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @POST
    @Path(value="/compact")
    @ResourceFilters(value={ConfigResourceFilter.class})
    @VisibleForTesting
    public Response forceTriggerCompaction() {
        this.coordinator.runCompactSegmentsDuty();
        return Response.ok().build();
    }

    @GET
    @Path(value="/progress")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getCompactionProgress(@QueryParam(value="dataSource") String dataSource) {
        Long notCompactedSegmentSizeBytes = this.coordinator.getTotalSizeOfSegmentsAwaitingCompaction(dataSource);
        if (notCompactedSegmentSizeBytes == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)"unknown dataSource")).build();
        }
        return Response.ok((Object)ImmutableMap.of((Object)"remainingSegmentSize", (Object)notCompactedSegmentSizeBytes)).build();
    }
}

