/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.server.coordinator.rules.BroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.Rules;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;

public class PeriodBroadcastDistributionRule
extends BroadcastDistributionRule {
    static final String TYPE = "broadcastByPeriod";
    private static final boolean DEFAULT_INCLUDE_FUTURE = true;
    private final Period period;
    private final boolean includeFuture;

    @JsonCreator
    public PeriodBroadcastDistributionRule(@JsonProperty(value="period") Period period, @JsonProperty(value="includeFuture") Boolean includeFuture) {
        this.period = period;
        this.includeFuture = includeFuture == null ? true : includeFuture;
    }

    @Override
    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        return Rules.eligibleForLoad(this.period, interval, referenceTimestamp, this.includeFuture);
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    @JsonProperty
    public boolean isIncludeFuture() {
        return this.includeFuture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodBroadcastDistributionRule that = (PeriodBroadcastDistributionRule)o;
        return this.isIncludeFuture() == that.isIncludeFuture() && Objects.equals(this.getPeriod(), that.getPeriod());
    }

    public int hashCode() {
        return Objects.hash(this.getPeriod(), this.isIncludeFuture());
    }
}

