/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;

public abstract class BroadcastDistributionRule
implements Rule {
    private static final EmittingLogger log = new EmittingLogger(BroadcastDistributionRule.class);

    @Override
    public CoordinatorStats run(DruidCoordinator coordinator, DruidCoordinatorRuntimeParams params, DataSegment segment) {
        HashSet<ServerHolder> dropServerHolders = new HashSet<ServerHolder>();
        Set<ServerHolder> loadServerHolders = params.getDruidCluster().getAllServers().stream().filter(serverHolder -> {
            ServerType serverType = serverHolder.getServer().getType();
            if (!serverType.isSegmentBroadcastTarget()) {
                return false;
            }
            boolean isServingSegment = serverHolder.isServingSegment(segment);
            if (serverHolder.isDecommissioning()) {
                if (isServingSegment && !serverHolder.isDroppingSegment(segment)) {
                    dropServerHolders.add((ServerHolder)serverHolder);
                }
                return false;
            }
            return !isServingSegment && !serverHolder.isLoadingSegment(segment);
        }).collect(Collectors.toSet());
        CoordinatorStats stats = new CoordinatorStats();
        return stats.accumulate(this.assign(loadServerHolders, segment)).accumulate(this.drop(dropServerHolders, segment));
    }

    @Override
    public boolean canLoadSegments() {
        return true;
    }

    @Override
    public void updateUnderReplicated(Map<String, Object2LongMap<String>> underReplicatedPerTier, SegmentReplicantLookup segmentReplicantLookup, DataSegment segment) {
        Object2LongMap<String> underReplicatedBroadcastTiers = segmentReplicantLookup.getBroadcastUnderReplication(segment.getId());
        for (Object2LongMap.Entry entry : underReplicatedBroadcastTiers.object2LongEntrySet()) {
            String tier = (String)entry.getKey();
            long underReplicatedCount = entry.getLongValue();
            underReplicatedPerTier.compute(tier, (_tier, existing) -> {
                Object2LongMap underReplicationPerDataSource = existing;
                if (existing == null) {
                    underReplicationPerDataSource = new Object2LongOpenHashMap();
                }
                underReplicationPerDataSource.compute((Object)segment.getDataSource(), (_datasource, count) -> count != null ? count + underReplicatedCount : underReplicatedCount);
                return underReplicationPerDataSource;
            });
        }
    }

    private CoordinatorStats assign(Set<ServerHolder> serverHolders, DataSegment segment) {
        CoordinatorStats stats = new CoordinatorStats();
        stats.addToGlobalStat("assignedCount", 0L);
        for (ServerHolder holder : serverHolders) {
            if (segment.getSize() > holder.getAvailableSize()) {
                log.makeAlert("Failed to broadcast segment for [%s]", new Object[]{segment.getDataSource()}).addData("segmentId", (Object)segment.getId()).addData("segmentSize", (Object)segment.getSize()).addData("hostName", (Object)holder.getServer().getHost()).addData("availableSize", (Object)holder.getAvailableSize()).emit();
                continue;
            }
            if (holder.isLoadingSegment(segment)) continue;
            holder.getPeon().loadSegment(segment, null);
            stats.addToGlobalStat("assignedCount", 1L);
        }
        return stats;
    }

    private CoordinatorStats drop(Set<ServerHolder> serverHolders, DataSegment segment) {
        CoordinatorStats stats = new CoordinatorStats();
        for (ServerHolder holder : serverHolders) {
            holder.getPeon().dropSegment(segment, null);
            stats.addToGlobalStat("droppedCount", 1L);
        }
        return stats;
    }
}

