/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;

final class ReservoirSegmentSampler {
    static BalancerSegmentHolder getRandomBalancerSegmentHolder(List<ServerHolder> serverHolders, Set<String> broadcastDatasources) {
        ServerHolder fromServerHolder = null;
        DataSegment proposalSegment = null;
        int numSoFar = 0;
        for (ServerHolder server : serverHolders) {
            if (!server.getServer().getType().isSegmentReplicationTarget()) continue;
            for (DataSegment segment : server.getServer().iterateAllSegments()) {
                if (broadcastDatasources.contains(segment.getDataSource())) continue;
                int randNum = ThreadLocalRandom.current().nextInt(numSoFar + 1);
                if (randNum == numSoFar) {
                    fromServerHolder = server;
                    proposalSegment = segment;
                }
                ++numSoFar;
            }
        }
        if (fromServerHolder != null) {
            return new BalancerSegmentHolder(fromServerHolder.getServer(), proposalSegment);
        }
        return null;
    }

    private ReservoirSegmentSampler() {
    }
}

