/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.server.coordinator.CuratorLoadQueuePeon;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.HttpLoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.initialization.ZkPathsConfig;

public class LoadQueueTaskMaster {
    private final CuratorFramework curator;
    private final ObjectMapper jsonMapper;
    private final ScheduledExecutorService peonExec;
    private final ExecutorService callbackExec;
    private final DruidCoordinatorConfig config;
    private final HttpClient httpClient;
    private final ZkPathsConfig zkPaths;

    public LoadQueueTaskMaster(CuratorFramework curator, ObjectMapper jsonMapper, ScheduledExecutorService peonExec, ExecutorService callbackExec, DruidCoordinatorConfig config, HttpClient httpClient, ZkPathsConfig zkPaths) {
        this.curator = curator;
        this.jsonMapper = jsonMapper;
        this.peonExec = peonExec;
        this.callbackExec = callbackExec;
        this.config = config;
        this.httpClient = httpClient;
        this.zkPaths = zkPaths;
    }

    public LoadQueuePeon giveMePeon(ImmutableDruidServer server) {
        if ("http".equalsIgnoreCase(this.config.getLoadQueuePeonType())) {
            return new HttpLoadQueuePeon(server.getURL(), this.jsonMapper, this.httpClient, this.config, this.peonExec, this.callbackExec);
        }
        return new CuratorLoadQueuePeon(this.curator, ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)server.getName()), this.jsonMapper, this.peonExec, this.callbackExec, this.config);
    }
}

