/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.joda.time.Period;

public class DataSourceCompactionConfig {
    public static final int DEFAULT_COMPACTION_TASK_PRIORITY = 25;
    private static final long DEFAULT_INPUT_SEGMENT_SIZE_BYTES = 0x19000000L;
    private static final Period DEFAULT_SKIP_OFFSET_FROM_LATEST = new Period((Object)"P1D");
    private final String dataSource;
    private final int taskPriority;
    private final long inputSegmentSizeBytes;
    @Nullable
    private final Integer maxRowsPerSegment;
    private final Period skipOffsetFromLatest;
    private final UserCompactionTaskQueryTuningConfig tuningConfig;
    private final Map<String, Object> taskContext;

    @JsonCreator
    public DataSourceCompactionConfig(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="taskPriority") @Nullable Integer taskPriority, @JsonProperty(value="inputSegmentSizeBytes") @Nullable Long inputSegmentSizeBytes, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="skipOffsetFromLatest") @Nullable Period skipOffsetFromLatest, @JsonProperty(value="tuningConfig") @Nullable UserCompactionTaskQueryTuningConfig tuningConfig, @JsonProperty(value="taskContext") @Nullable Map<String, Object> taskContext) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.taskPriority = taskPriority == null ? 25 : taskPriority;
        this.inputSegmentSizeBytes = inputSegmentSizeBytes == null ? 0x19000000L : inputSegmentSizeBytes;
        this.maxRowsPerSegment = maxRowsPerSegment;
        this.skipOffsetFromLatest = skipOffsetFromLatest == null ? DEFAULT_SKIP_OFFSET_FROM_LATEST : skipOffsetFromLatest;
        this.tuningConfig = tuningConfig;
        this.taskContext = taskContext;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public int getTaskPriority() {
        return this.taskPriority;
    }

    @JsonProperty
    public long getInputSegmentSizeBytes() {
        return this.inputSegmentSizeBytes;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    public Period getSkipOffsetFromLatest() {
        return this.skipOffsetFromLatest;
    }

    @JsonProperty
    @Nullable
    public UserCompactionTaskQueryTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    @Nullable
    public Map<String, Object> getTaskContext() {
        return this.taskContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceCompactionConfig that = (DataSourceCompactionConfig)o;
        return this.taskPriority == that.taskPriority && this.inputSegmentSizeBytes == that.inputSegmentSizeBytes && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.skipOffsetFromLatest, that.skipOffsetFromLatest) && Objects.equals(this.tuningConfig, that.tuningConfig) && Objects.equals(this.taskContext, that.taskContext);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.taskPriority, this.inputSegmentSizeBytes, this.skipOffsetFromLatest, this.tuningConfig, this.taskContext);
    }
}

