/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.druid.client.CachingQueryRunner;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.guice.annotations.Processing;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.PerSegmentOptimizingQueryRunner;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.ReferenceCountingSegmentQueryRunner;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.Joinables;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final ExecutorService exec;
    private final CachePopulator cachePopulator;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    private final SegmentManager segmentManager;
    private final JoinableFactory joinableFactory;
    private final ServerConfig serverConfig;

    @Inject
    public ServerManager(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, JoinableFactory joinableFactory, ServerConfig serverConfig) {
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.exec = exec;
        this.cachePopulator = cachePopulator;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.segmentManager = segmentManager;
        this.joinableFactory = joinableFactory;
        this.serverConfig = serverConfig;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)query.getDataSource());
        Optional<VersionedIntervalTimeline<String, ReferenceCountingSegment>> maybeTimeline = this.segmentManager.getTimeline(analysis);
        if (!maybeTimeline.isPresent()) {
            return new NoopQueryRunner();
        }
        VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = maybeTimeline.get();
        FunctionalIterable segmentDescriptors = FunctionalIterable.create(intervals).transformCat(arg_0 -> timeline.lookup(arg_0)).transformCat(holder -> {
            if (holder == null) {
                return null;
            }
            return FunctionalIterable.create((Iterable)holder.getObject()).transform(partitionChunk -> new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), partitionChunk.getChunkNumber()));
        });
        return this.getQueryRunnerForSegments(query, (Iterable<SegmentDescriptor>)segmentDescriptors);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            log.makeAlert("Unknown query type, [%s]", new Object[]{query.getClass()}).addData("dataSource", (Object)query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        QueryToolChest toolChest = factory.getToolchest();
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)query.getDataSource());
        AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        Optional<VersionedIntervalTimeline<String, ReferenceCountingSegment>> maybeTimeline = this.segmentManager.getTimeline(analysis);
        if (analysis.isQuery() && !toolChest.canPerformSubquery(((QueryDataSource)analysis.getDataSource()).getQuery())) {
            throw new ISE("Cannot handle subquery: %s", new Object[]{analysis.getDataSource()});
        }
        if (!maybeTimeline.isPresent()) {
            return new NoopQueryRunner();
        }
        VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = maybeTimeline.get();
        Function segmentMapFn = Joinables.createSegmentMapFn((List)analysis.getPreJoinableClauses(), (JoinableFactory)this.joinableFactory, (AtomicLong)cpuTimeAccumulator, analysis.getBaseQuery().orElse(query));
        FunctionalIterable queryRunners = FunctionalIterable.create(specs).transformCat(descriptor -> {
            PartitionHolder entry = timeline.findEntry(descriptor.getInterval(), (Object)descriptor.getVersion());
            if (entry == null) {
                return Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(descriptor));
            }
            PartitionChunk chunk = entry.getChunk(descriptor.getPartitionNumber());
            if (chunk == null) {
                return Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(descriptor));
            }
            ReferenceCountingSegment segment = (ReferenceCountingSegment)chunk.getObject();
            return Collections.singletonList(this.buildAndDecorateQueryRunner((QueryRunnerFactory)factory, (QueryToolChest)toolChest, (SegmentReference)segmentMapFn.apply(segment), (SegmentDescriptor)descriptor, cpuTimeAccumulator));
        });
        return CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)queryRunners)), toolChest), (QueryToolChest)toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, SegmentReference segment, SegmentDescriptor segmentDescriptor, AtomicLong cpuTimeAccumulator) {
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        SegmentId segmentId = segment.getId();
        Interval segmentInterval = segment.getDataInterval();
        if (segmentId == null || segmentInterval == null) {
            return new ReportTimelineMissingSegmentQueryRunner(segmentDescriptor);
        }
        String segmentIdString = segmentId.toString();
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerInner = new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)new ReferenceCountingSegmentQueryRunner(factory, segment, segmentDescriptor), QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(segmentIdString));
        CachingQueryRunner cachingQueryRunner = new CachingQueryRunner(segmentIdString, segmentDescriptor, this.objectMapper, this.cache, (QueryToolChest)toolChest, metricsEmittingQueryRunnerInner, this.cachePopulator, this.cacheConfig);
        BySegmentQueryRunner bySegmentQueryRunner = new BySegmentQueryRunner(segmentId, segmentInterval.getStart(), cachingQueryRunner);
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerOuter = new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)bySegmentQueryRunner, QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(segmentIdString)).withWaitMeasuredFromNow();
        SpecificSegmentQueryRunner specificSegmentQueryRunner = new SpecificSegmentQueryRunner((QueryRunner)metricsEmittingQueryRunnerOuter, segmentSpec);
        PerSegmentOptimizingQueryRunner perSegmentOptimizingQueryRunner = new PerSegmentOptimizingQueryRunner((QueryRunner)specificSegmentQueryRunner, new PerSegmentQueryOptimizationContext(segmentDescriptor));
        return new SetAndVerifyContextQueryRunner(this.serverConfig, CPUTimeMetricQueryRunner.safeBuild((QueryRunner)perSegmentOptimizingQueryRunner, toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)false));
    }
}

