/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FluentQueryRunnerBuilder;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.Joinables;
import org.apache.druid.server.QueryScheduler;
import org.joda.time.Interval;

public class LocalQuerySegmentWalker
implements QuerySegmentWalker {
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final SegmentWrangler segmentWrangler;
    private final JoinableFactory joinableFactory;
    private final QueryScheduler scheduler;
    private final ServiceEmitter emitter;

    @Inject
    public LocalQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate, SegmentWrangler segmentWrangler, JoinableFactory joinableFactory, QueryScheduler scheduler, ServiceEmitter emitter) {
        this.conglomerate = conglomerate;
        this.segmentWrangler = segmentWrangler;
        this.joinableFactory = joinableFactory;
        this.scheduler = scheduler;
        this.emitter = emitter;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)query.getDataSource());
        if (!analysis.isConcreteBased() || !analysis.isGlobal()) {
            throw new IAE("Cannot query dataSource locally: %s", new Object[]{analysis.getDataSource()});
        }
        FunctionalIterable segments = FunctionalIterable.create((Iterable)this.segmentWrangler.getSegmentsForIntervals(analysis.getBaseDataSource(), intervals)).transform(ReferenceCountingSegment::wrapRootGenerationSegment);
        AtomicLong cpuAccumulator = new AtomicLong(0L);
        Function segmentMapFn = Joinables.createSegmentMapFn((List)analysis.getPreJoinableClauses(), (JoinableFactory)this.joinableFactory, (AtomicLong)cpuAccumulator, analysis.getBaseQuery().orElse(query));
        QueryRunnerFactory queryRunnerFactory = this.conglomerate.findFactory(query);
        QueryRunner baseRunner = queryRunnerFactory.mergeRunners((ExecutorService)Execs.directExecutor(), () -> LocalQuerySegmentWalker.lambda$getQueryRunnerForIntervals$0((Iterable)segments, segmentMapFn, queryRunnerFactory));
        return new FluentQueryRunnerBuilder(queryRunnerFactory.getToolchest()).create(this.scheduler.wrapQueryRunner(baseRunner)).applyPreMergeDecoration().mergeResults().applyPostMergeDecoration().emitCPUTimeMetric(this.emitter, cpuAccumulator);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        throw new ISE("Cannot run with specific segments", new Object[0]);
    }

    private static /* synthetic */ Iterator lambda$getQueryRunnerForIntervals$0(Iterable segments, Function segmentMapFn, QueryRunnerFactory queryRunnerFactory) {
        return StreamSupport.stream(segments.spliterator(), false).map(segmentMapFn).map(arg_0 -> ((QueryRunnerFactory)queryRunnerFactory).createRunner(arg_0)).iterator();
    }
}

