/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;

public class OmniDataSegmentKiller
implements DataSegmentKiller {
    private final Map<String, DataSegmentKiller> killers;

    @Inject
    public OmniDataSegmentKiller(Map<String, DataSegmentKiller> killers) {
        this.killers = killers;
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        this.getKiller(segment).kill(segment);
    }

    private DataSegmentKiller getKiller(DataSegment segment) throws SegmentLoadingException {
        String type = MapUtils.getString((Map)segment.getLoadSpec(), (String)"type");
        DataSegmentKiller loader = this.killers.get(type);
        if (loader == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", new Object[]{type, this.killers.keySet()});
        }
        return loader;
    }

    public void killAll() {
        throw new UnsupportedOperationException("not implemented");
    }
}

