/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskIdUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.transform.TransformSpec;

public class DataSchema {
    private static final Logger log = new Logger(DataSchema.class);
    private static final Pattern INVALIDCHARS = Pattern.compile("(?s).*[^\\S ].*");
    private final String dataSource;
    private final AggregatorFactory[] aggregators;
    private final GranularitySpec granularitySpec;
    private final TransformSpec transformSpec;
    private final Map<String, Object> parserMap;
    private final ObjectMapper objectMapper;
    private TimestampSpec timestampSpec;
    private DimensionsSpec dimensionsSpec;
    private InputRowParser inputRowParser;

    @JsonCreator
    public DataSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="timestampSpec") @Nullable TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") @Nullable DimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") AggregatorFactory[] aggregators, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="transformSpec") TransformSpec transformSpec, @Deprecated @JsonProperty(value="parser") @Nullable Map<String, Object> parserMap, @JacksonInject ObjectMapper objectMapper) {
        DataSchema.validateDatasourceName(dataSource);
        this.dataSource = dataSource;
        this.timestampSpec = timestampSpec;
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
        DimensionsSpec dimensionsSpec2 = this.dimensionsSpec = dimensionsSpec == null ? null : DataSchema.computeDimensionsSpec((TimestampSpec)Preconditions.checkNotNull((Object)timestampSpec, (Object)"timestampSpec"), dimensionsSpec, this.aggregators);
        if (granularitySpec == null) {
            log.warn("No granularitySpec has been specified. Using UniformGranularitySpec as default.", new Object[0]);
            this.granularitySpec = new UniformGranularitySpec(null, null, null);
        } else {
            this.granularitySpec = granularitySpec;
        }
        this.transformSpec = transformSpec == null ? TransformSpec.NONE : transformSpec;
        this.parserMap = parserMap;
        this.objectMapper = objectMapper;
        if (aggregators != null && aggregators.length != 0) {
            HashSet<String> names = new HashSet<String>();
            for (AggregatorFactory factory : aggregators) {
                if (names.add(factory.getName())) continue;
                throw new IAE("duplicate aggregators found with name [%s].", new Object[]{factory.getName()});
            }
        } else if (this.granularitySpec.isRollup()) {
            log.warn("No metricsSpec has been specified. Are you sure this is what you want?", new Object[0]);
        }
    }

    @VisibleForTesting
    public DataSchema(String dataSource, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, AggregatorFactory[] aggregators, GranularitySpec granularitySpec, TransformSpec transformSpec) {
        this(dataSource, timestampSpec, dimensionsSpec, aggregators, granularitySpec, transformSpec, null, null);
    }

    @Deprecated
    public DataSchema(String dataSource, Map<String, Object> parserMap, AggregatorFactory[] aggregators, GranularitySpec granularitySpec, TransformSpec transformSpec, ObjectMapper objectMapper) {
        this(dataSource, null, null, aggregators, granularitySpec, transformSpec, parserMap, objectMapper);
    }

    private static void validateDatasourceName(String dataSource) {
        TaskIdUtils.validateId((String)"dataSource", (String)dataSource);
    }

    private static DimensionsSpec computeDimensionsSpec(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, AggregatorFactory[] aggregators) {
        HashSet dimSet;
        HashSet<String> dimensionExclusions = new HashSet<String>();
        String timestampColumn = timestampSpec.getTimestampColumn();
        if (!dimensionsSpec.hasCustomDimensions() || !dimensionsSpec.getDimensionNames().contains(timestampColumn)) {
            dimensionExclusions.add(timestampColumn);
        }
        for (AggregatorFactory aggregator : aggregators) {
            dimensionExclusions.addAll(aggregator.requiredFields());
            dimensionExclusions.add(aggregator.getName());
        }
        Set metSet = Arrays.stream(aggregators).map(AggregatorFactory::getName).collect(Collectors.toSet());
        Sets.SetView overlap = Sets.intersection(metSet, dimSet = new HashSet(dimensionsSpec.getDimensionNames()));
        if (!overlap.isEmpty()) {
            throw new IAE("Cannot have overlapping dimensions and metrics of the same name. Please change the name of the metric. Overlap: %s", new Object[]{overlap});
        }
        return dimensionsSpec.withDimensionExclusions((Set)Sets.difference(dimensionExclusions, dimSet));
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Nullable
    @JsonProperty(value="timestampSpec")
    private TimestampSpec getGivenTimestampSpec() {
        return this.timestampSpec;
    }

    public TimestampSpec getTimestampSpec() {
        if (this.timestampSpec == null) {
            this.timestampSpec = ((InputRowParser)Preconditions.checkNotNull((Object)this.getParser(), (Object)"inputRowParser")).getParseSpec().getTimestampSpec();
        }
        return this.timestampSpec;
    }

    @Nullable
    @JsonProperty(value="dimensionsSpec")
    private DimensionsSpec getGivenDimensionsSpec() {
        return this.dimensionsSpec;
    }

    public DimensionsSpec getDimensionsSpec() {
        if (this.dimensionsSpec == null) {
            this.dimensionsSpec = DataSchema.computeDimensionsSpec(this.getTimestampSpec(), ((InputRowParser)Preconditions.checkNotNull((Object)this.getParser(), (Object)"inputRowParser")).getParseSpec().getDimensionsSpec(), this.aggregators);
        }
        return this.dimensionsSpec;
    }

    @JsonProperty(value="metricsSpec")
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    public TransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    @Deprecated
    @JsonProperty(value="parser")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getParserMap() {
        return this.parserMap;
    }

    @Nullable
    public InputRowParser getParser() {
        if (this.inputRowParser == null) {
            if (this.parserMap == null) {
                return null;
            }
            this.inputRowParser = this.transformSpec.decorate((InputRowParser)this.objectMapper.convertValue(this.parserMap, InputRowParser.class));
            ParseSpec parseSpec = this.inputRowParser.getParseSpec();
            parseSpec = parseSpec.withDimensionsSpec(DataSchema.computeDimensionsSpec(parseSpec.getTimestampSpec(), parseSpec.getDimensionsSpec(), this.aggregators));
            if (this.timestampSpec != null) {
                parseSpec = parseSpec.withTimestampSpec(this.timestampSpec);
            }
            if (this.dimensionsSpec != null) {
                parseSpec = parseSpec.withDimensionsSpec(this.dimensionsSpec);
            }
            this.inputRowParser = this.inputRowParser.withParseSpec(parseSpec);
        }
        return this.inputRowParser;
    }

    public DataSchema withGranularitySpec(GranularitySpec granularitySpec) {
        return new DataSchema(this.dataSource, this.timestampSpec, this.dimensionsSpec, this.aggregators, granularitySpec, this.transformSpec, this.parserMap, this.objectMapper);
    }

    public DataSchema withTransformSpec(TransformSpec transformSpec) {
        return new DataSchema(this.dataSource, this.timestampSpec, this.dimensionsSpec, this.aggregators, this.granularitySpec, transformSpec, this.parserMap, this.objectMapper);
    }

    public String toString() {
        return "DataSchema{dataSource='" + this.dataSource + '\'' + ", aggregators=" + Arrays.toString(this.aggregators) + ", granularitySpec=" + this.granularitySpec + ", transformSpec=" + this.transformSpec + ", parserMap=" + this.parserMap + ", timestampSpec=" + this.timestampSpec + ", dimensionsSpec=" + this.dimensionsSpec + ", inputRowParser=" + this.inputRowParser + '}';
    }
}

