/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.metadata.UnknownSegmentIdsException;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public interface SegmentsMetadataManager {
    public void startPollingDatabasePeriodically();

    public void stopPollingDatabasePeriodically();

    public boolean isPollingDatabasePeriodically();

    public int markAsUsedAllNonOvershadowedSegmentsInDataSource(String var1);

    public int markAsUsedNonOvershadowedSegmentsInInterval(String var1, Interval var2);

    public int markAsUsedNonOvershadowedSegments(String var1, Set<String> var2) throws UnknownSegmentIdsException;

    public boolean markSegmentAsUsed(String var1);

    public int markAsUnusedAllSegmentsInDataSource(String var1);

    public int markAsUnusedSegmentsInInterval(String var1, Interval var2);

    public int markSegmentsAsUnused(String var1, Set<String> var2);

    public boolean markSegmentAsUnused(String var1);

    @Nullable
    public ImmutableDruidDataSource getImmutableDataSourceWithUsedSegments(String var1);

    public Collection<ImmutableDruidDataSource> getImmutableDataSourcesWithAllUsedSegments();

    public Set<SegmentId> getOvershadowedSegments();

    public DataSourcesSnapshot getSnapshotOfDataSourcesWithAllUsedSegments();

    public Iterable<DataSegment> iterateAllUsedSegments();

    public Optional<Iterable<DataSegment>> iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(String var1, Interval var2, boolean var3);

    public Set<String> retrieveAllDataSourceNames();

    public List<Interval> getUnusedSegmentIntervals(String var1, DateTime var2, int var3);

    @VisibleForTesting
    public void poll();
}

