/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.joda.time.Interval;

public interface IndexerMetadataStorageCoordinator {
    default public Collection<DataSegment> retrieveUsedSegmentsForInterval(String dataSource, Interval interval, Segments visibility) {
        return this.retrieveUsedSegmentsForIntervals(dataSource, Collections.singletonList(interval), visibility);
    }

    public Collection<DataSegment> retrieveAllUsedSegments(String var1, Segments var2);

    public Collection<Pair<DataSegment, String>> retrieveUsedSegmentsAndCreatedDates(String var1);

    public Collection<DataSegment> retrieveUsedSegmentsForIntervals(String var1, List<Interval> var2, Segments var3);

    public List<DataSegment> retrieveUnusedSegmentsForInterval(String var1, Interval var2);

    public Set<DataSegment> announceHistoricalSegments(Set<DataSegment> var1) throws IOException;

    public SegmentIdWithShardSpec allocatePendingSegment(String var1, String var2, @Nullable String var3, Interval var4, PartialShardSpec var5, String var6, boolean var7);

    public int deletePendingSegmentsCreatedInInterval(String var1, Interval var2);

    public int deletePendingSegments(String var1);

    public SegmentPublishResult announceHistoricalSegments(Set<DataSegment> var1, @Nullable DataSourceMetadata var2, @Nullable DataSourceMetadata var3) throws IOException;

    @Nullable
    public DataSourceMetadata retrieveDataSourceMetadata(String var1);

    public boolean deleteDataSourceMetadata(String var1);

    public boolean resetDataSourceMetadata(String var1, DataSourceMetadata var2) throws IOException;

    public boolean insertDataSourceMetadata(String var1, DataSourceMetadata var2);

    public SegmentPublishResult commitMetadataOnly(String var1, DataSourceMetadata var2, DataSourceMetadata var3);

    public void updateSegmentMetadata(Set<DataSegment> var1);

    public void deleteSegments(Set<DataSegment> var1);
}

