/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import java.util.Map;
import org.apache.druid.guice.DruidBinders;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.segment.join.InlineJoinableFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.LookupJoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;

public class JoinableFactoryModule
implements Module {
    @VisibleForTesting
    static final Map<Class<? extends DataSource>, Class<? extends JoinableFactory>> FACTORY_MAPPINGS = ImmutableMap.of(InlineDataSource.class, InlineJoinableFactory.class, LookupDataSource.class, LookupJoinableFactory.class);

    public void configure(Binder binder) {
        MapBinder<Class<? extends DataSource>, JoinableFactory> joinableFactories = DruidBinders.joinableFactoryBinder(binder);
        FACTORY_MAPPINGS.forEach((ds, factory) -> {
            joinableFactories.addBinding(ds).to(factory);
            binder.bind(factory).in(LazySingleton.class);
        });
        binder.bind(JoinableFactory.class).to(MapJoinableFactory.class).in(Scopes.SINGLETON);
    }
}

