/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.GuiceExprMacroTable;
import org.apache.druid.query.expression.IPv4AddressMatchExprMacro;
import org.apache.druid.query.expression.IPv4AddressParseExprMacro;
import org.apache.druid.query.expression.IPv4AddressStringifyExprMacro;
import org.apache.druid.query.expression.LikeExprMacro;
import org.apache.druid.query.expression.RegexpExtractExprMacro;
import org.apache.druid.query.expression.RegexpLikeExprMacro;
import org.apache.druid.query.expression.TimestampCeilExprMacro;
import org.apache.druid.query.expression.TimestampExtractExprMacro;
import org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.druid.query.expression.TimestampFormatExprMacro;
import org.apache.druid.query.expression.TimestampParseExprMacro;
import org.apache.druid.query.expression.TimestampShiftExprMacro;
import org.apache.druid.query.expression.TrimExprMacro;

public class ExpressionModule
implements DruidModule {
    public static final List<Class<? extends ExprMacroTable.ExprMacro>> EXPR_MACROS = ImmutableList.builder().add(IPv4AddressMatchExprMacro.class).add(IPv4AddressParseExprMacro.class).add(IPv4AddressStringifyExprMacro.class).add(LikeExprMacro.class).add(RegexpExtractExprMacro.class).add(RegexpLikeExprMacro.class).add(TimestampCeilExprMacro.class).add(TimestampExtractExprMacro.class).add(TimestampFloorExprMacro.class).add(TimestampFormatExprMacro.class).add(TimestampParseExprMacro.class).add(TimestampShiftExprMacro.class).add(TrimExprMacro.BothTrimExprMacro.class).add(TrimExprMacro.LeftTrimExprMacro.class).add(TrimExprMacro.RightTrimExprMacro.class).build();

    public void configure(Binder binder) {
        binder.bind(ExprMacroTable.class).to(GuiceExprMacroTable.class).in(LazySingleton.class);
        for (Class<? extends ExprMacroTable.ExprMacro> exprMacroClass : EXPR_MACROS) {
            ExpressionModule.addExprMacro(binder, exprMacroClass);
        }
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of();
    }

    public static void addExprMacro(Binder binder, Class<? extends ExprMacroTable.ExprMacro> clazz) {
        Multibinder.newSetBinder((Binder)binder, ExprMacroTable.ExprMacro.class).addBinding().to(clazz);
    }
}

