/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.client.selector.DiscoverySelector;
import org.apache.druid.client.selector.Server;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.FullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DruidLeaderClient {
    private final Logger log = new Logger(DruidLeaderClient.class);
    private static final int MAX_RETRIES = 5;
    private final HttpClient httpClient;
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private final NodeRole nodeRoleToWatch;
    private final String leaderRequestPath;
    private final DiscoverySelector<Server> serverDiscoverySelector;
    private LifecycleLock lifecycleLock = new LifecycleLock();
    private DruidNodeDiscovery druidNodeDiscovery;
    private AtomicReference<String> currentKnownLeader = new AtomicReference();

    public DruidLeaderClient(HttpClient httpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, NodeRole nodeRoleToWatch, String leaderRequestPath, DiscoverySelector<Server> serverDiscoverySelector) {
        this.httpClient = httpClient;
        this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
        this.nodeRoleToWatch = nodeRoleToWatch;
        this.leaderRequestPath = leaderRequestPath;
        this.serverDiscoverySelector = serverDiscoverySelector;
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            this.druidNodeDiscovery = this.druidNodeDiscoveryProvider.getForNodeRole(this.nodeRoleToWatch);
            this.lifecycleLock.started();
            this.log.debug("Started.", new Object[0]);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        this.log.debug("Stopped.", new Object[0]);
    }

    public Request makeRequest(HttpMethod httpMethod, String urlPath, boolean cached) throws IOException {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        return new Request(httpMethod, new URL(StringUtils.format((String)"%s%s", (Object[])new Object[]{this.getCurrentKnownLeader(cached), urlPath})));
    }

    public Request makeRequest(HttpMethod httpMethod, String urlPath) throws IOException {
        return this.makeRequest(httpMethod, urlPath, true);
    }

    public StringFullResponseHolder go(Request request) throws IOException, InterruptedException {
        return (StringFullResponseHolder)this.go(request, (HttpResponseHandler)new StringFullResponseHandler(StandardCharsets.UTF_8));
    }

    public <Intermediate, Final> ListenableFuture<Final> goAsync(Request request, HttpResponseHandler<Intermediate, Final> handler) {
        return this.httpClient.go(request, handler);
    }

    public <T, H extends FullResponseHolder<T>> H go(Request request, HttpResponseHandler<H, H> responseHandler) throws IOException, InterruptedException {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        for (int counter = 0; counter < 5; ++counter) {
            FullResponseHolder fullResponseHolder;
            try {
                try {
                    fullResponseHolder = (FullResponseHolder)this.httpClient.go(request, responseHandler).get();
                }
                catch (ExecutionException e) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ChannelException.class);
                    throw new RE((Throwable)e, "HTTP request to[%s] failed", new Object[]{request.getUrl()});
                }
            }
            catch (IOException | ChannelException ex) {
                this.log.warn(ex, "Request[%s] failed.", new Object[]{request.getUrl()});
                try {
                    if (request.getUrl().getQuery() == null) {
                        request = this.withUrl(request, new URL(StringUtils.format((String)"%s%s", (Object[])new Object[]{this.getCurrentKnownLeader(false), request.getUrl().getPath()})));
                        continue;
                    }
                    request = this.withUrl(request, new URL(StringUtils.format((String)"%s%s?%s", (Object[])new Object[]{this.getCurrentKnownLeader(false), request.getUrl().getPath(), request.getUrl().getQuery()})));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new ISE((Throwable)e, "failed to build url with path[%] and query string [%s].", new Object[]{request.getUrl().getPath(), request.getUrl().getQuery()});
                }
            }
            if (HttpResponseStatus.TEMPORARY_REDIRECT.equals((Object)fullResponseHolder.getResponse().getStatus())) {
                URL redirectUrl;
                String redirectUrlStr = fullResponseHolder.getResponse().headers().get("Location");
                if (redirectUrlStr == null) {
                    throw new IOE("No redirect location is found in response from url[%s].", new Object[]{request.getUrl()});
                }
                this.log.info("Request[%s] received redirect response to location [%s].", new Object[]{request.getUrl(), redirectUrlStr});
                try {
                    redirectUrl = new URL(redirectUrlStr);
                }
                catch (MalformedURLException ex) {
                    throw new IOE((Throwable)ex, "Malformed redirect location is found in response from url[%s], new location[%s].", new Object[]{request.getUrl(), redirectUrlStr});
                }
                this.currentKnownLeader.set(StringUtils.format((String)"%s://%s:%s", (Object[])new Object[]{redirectUrl.getProtocol(), redirectUrl.getHost(), redirectUrl.getPort()}));
                request = this.withUrl(request, redirectUrl);
                continue;
            }
            return (H)fullResponseHolder;
        }
        throw new IOE("Retries exhausted, couldn't fulfill request to [%s].", new Object[]{request.getUrl()});
    }

    public String findCurrentLeader() {
        StringFullResponseHolder responseHolder;
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        try {
            responseHolder = this.go(this.makeRequest(HttpMethod.GET, this.leaderRequestPath));
        }
        catch (Exception ex) {
            throw new ISE((Throwable)ex, "Couldn't find leader.", new Object[0]);
        }
        if (responseHolder.getStatus().getCode() == 200) {
            String leaderUrl = responseHolder.getContent();
            try {
                URL validatedUrl = new URL(leaderUrl);
                this.currentKnownLeader.set(leaderUrl);
                return validatedUrl.toString();
            }
            catch (MalformedURLException ex) {
                this.log.error((Throwable)ex, "Received malformed leader url[%s].", new Object[]{leaderUrl});
            }
        }
        throw new ISE("Couldn't find leader, failed response status is [%s] and content [%s].", new Object[]{responseHolder.getStatus().getCode(), responseHolder.getContent()});
    }

    private String getCurrentKnownLeader(boolean cached) throws IOException {
        String leader = this.currentKnownLeader.accumulateAndGet(null, (current, given) -> current == null || !cached ? this.pickOneHost() : current);
        if (leader == null) {
            throw new IOE("No known server", new Object[0]);
        }
        return leader;
    }

    @Nullable
    private String pickOneHost() {
        Server server = this.serverDiscoverySelector.pick();
        if (server != null) {
            return StringUtils.format((String)"%s://%s:%s", (Object[])new Object[]{server.getScheme(), server.getAddress(), server.getPort()});
        }
        Iterator<DiscoveryDruidNode> iter = this.druidNodeDiscovery.getAllNodes().iterator();
        if (iter.hasNext()) {
            DiscoveryDruidNode node = iter.next();
            return StringUtils.format((String)"%s://%s", (Object[])new Object[]{node.getDruidNode().getServiceScheme(), node.getDruidNode().getHostAndPortToUse()});
        }
        return null;
    }

    private Request withUrl(Request old, URL url) {
        Request req = new Request(old.getMethod(), url);
        req.addHeaderValues(old.getHeaders());
        if (old.hasContent()) {
            req.setContent(old.getContent());
        }
        return req;
    }
}

