/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;

public class ClientCompactionTaskQueryTuningConfig {
    @Nullable
    private final Integer maxRowsPerSegment;
    @Nullable
    private final Integer maxRowsInMemory;
    @Nullable
    private final Long maxBytesInMemory;
    @Nullable
    private final Long maxTotalRows;
    @Nullable
    private final SplitHintSpec splitHintSpec;
    @Nullable
    private final IndexSpec indexSpec;
    @Nullable
    private final Integer maxPendingPersists;
    @Nullable
    private final Long pushTimeout;
    @Nullable
    private final Integer maxNumConcurrentSubTasks;

    public static ClientCompactionTaskQueryTuningConfig from(@Nullable UserCompactionTaskQueryTuningConfig userCompactionTaskQueryTuningConfig, @Nullable Integer maxRowsPerSegment) {
        if (userCompactionTaskQueryTuningConfig == null) {
            return new ClientCompactionTaskQueryTuningConfig(maxRowsPerSegment, null, null, null, null, null, null, null, null);
        }
        return new ClientCompactionTaskQueryTuningConfig(maxRowsPerSegment, userCompactionTaskQueryTuningConfig.getMaxRowsInMemory(), userCompactionTaskQueryTuningConfig.getMaxBytesInMemory(), userCompactionTaskQueryTuningConfig.getMaxTotalRows(), userCompactionTaskQueryTuningConfig.getSplitHintSpec(), userCompactionTaskQueryTuningConfig.getIndexSpec(), userCompactionTaskQueryTuningConfig.getMaxPendingPersists(), userCompactionTaskQueryTuningConfig.getPushTimeout(), userCompactionTaskQueryTuningConfig.getMaxNumConcurrentSubTasks());
    }

    @JsonCreator
    public ClientCompactionTaskQueryTuningConfig(@JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="maxTotalRows") @Nullable Long maxTotalRows, @JsonProperty(value="splitHintSpec") @Nullable SplitHintSpec splitHintSpec, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="maxNumConcurrentSubTasks") @Nullable Integer maxNumConcurrentSubTasks) {
        this.maxRowsPerSegment = maxRowsPerSegment;
        this.maxRowsInMemory = maxRowsInMemory;
        this.maxBytesInMemory = maxBytesInMemory;
        this.maxTotalRows = maxTotalRows;
        this.splitHintSpec = splitHintSpec;
        this.indexSpec = indexSpec;
        this.maxPendingPersists = maxPendingPersists;
        this.pushTimeout = pushTimeout;
        this.maxNumConcurrentSubTasks = maxNumConcurrentSubTasks;
    }

    @JsonProperty
    public String getType() {
        return "index_parallel";
    }

    @JsonProperty
    @Nullable
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @JsonProperty
    @Nullable
    public Long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    @JsonProperty
    @Nullable
    public Long getMaxTotalRows() {
        return this.maxTotalRows;
    }

    @Nullable
    @JsonProperty
    public SplitHintSpec getSplitHintSpec() {
        return this.splitHintSpec;
    }

    public long getMaxTotalRowsOr(long defaultMaxTotalRows) {
        return this.maxTotalRows == null ? defaultMaxTotalRows : this.maxTotalRows;
    }

    @JsonProperty
    @Nullable
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    @Nullable
    public Long getPushTimeout() {
        return this.pushTimeout;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxNumConcurrentSubTasks() {
        return this.maxNumConcurrentSubTasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionTaskQueryTuningConfig that = (ClientCompactionTaskQueryTuningConfig)o;
        return Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.maxBytesInMemory, that.maxBytesInMemory) && Objects.equals(this.maxRowsInMemory, that.maxRowsInMemory) && Objects.equals(this.maxTotalRows, that.maxTotalRows) && Objects.equals(this.splitHintSpec, that.splitHintSpec) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.maxPendingPersists, that.maxPendingPersists) && Objects.equals(this.pushTimeout, that.pushTimeout) && Objects.equals(this.maxNumConcurrentSubTasks, that.maxNumConcurrentSubTasks);
    }

    public int hashCode() {
        return Objects.hash(this.maxRowsPerSegment, this.maxBytesInMemory, this.maxRowsInMemory, this.maxTotalRows, this.splitHintSpec, this.indexSpec, this.maxPendingPersists, this.pushTimeout, this.maxNumConcurrentSubTasks);
    }

    public String toString() {
        return "ClientCompactQueryTuningConfig{maxRowsPerSegment=" + this.maxRowsPerSegment + ", maxRowsInMemory=" + this.maxRowsInMemory + ", maxBytesInMemory=" + this.maxBytesInMemory + ", maxTotalRows=" + this.maxTotalRows + ", splitHintSpec=" + this.splitHintSpec + ", indexSpec=" + this.indexSpec + ", maxPendingPersists=" + this.maxPendingPersists + ", pushTimeout=" + this.pushTimeout + ", maxNumConcurrentSubTasks=" + this.maxNumConcurrentSubTasks + '}';
    }
}

