/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.utils.CollectionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class CollectionUtilsTest {
    Set<String> empty = ImmutableSet.of();
    Set<String> abc = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c");
    Set<String> bcd = ImmutableSet.of((Object)"b", (Object)"c", (Object)"d");
    Set<String> efg = ImmutableSet.of((Object)"e", (Object)"f", (Object)"g");

    @Test
    public void testSubtract() {
        Assert.assertEquals(this.empty, (Object)CollectionUtils.subtract(this.empty, this.empty));
        Assert.assertEquals(this.abc, (Object)CollectionUtils.subtract(this.abc, this.empty));
        Assert.assertEquals(this.empty, (Object)CollectionUtils.subtract(this.abc, this.abc));
        Assert.assertEquals(this.abc, (Object)CollectionUtils.subtract(this.abc, this.efg));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a"), (Object)CollectionUtils.subtract(this.abc, this.bcd));
    }

    @Test
    public void testIntersect() {
        Assert.assertEquals(this.empty, (Object)CollectionUtils.intersect(this.empty, this.empty));
        Assert.assertEquals(this.abc, (Object)CollectionUtils.intersect(this.abc, this.abc));
        Assert.assertEquals(this.empty, (Object)CollectionUtils.intersect(this.abc, this.efg));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"b", (Object)"c"), (Object)CollectionUtils.intersect(this.abc, this.bcd));
    }

    @Test
    public void testUnion() {
        Assert.assertEquals(this.empty, (Object)CollectionUtils.union(this.empty, this.empty));
        Assert.assertEquals(this.abc, (Object)CollectionUtils.union(this.abc, this.abc));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"e", (Object)"f", (Object)"g", (Object[])new String[0]), (Object)CollectionUtils.union(this.abc, this.efg));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object)CollectionUtils.union(this.abc, this.bcd));
    }

    @Test
    public void testGetOnlyElement_empty() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> CollectionUtils.getOnlyElement(Collections.emptyList(), xs -> new ISE("oops", new Object[0])));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"oops")));
    }

    @Test
    public void testGetOnlyElement_one() {
        Assert.assertEquals((Object)"a", (Object)CollectionUtils.getOnlyElement(Collections.singletonList("a"), xs -> new ISE("oops", new Object[0])));
    }

    @Test
    public void testGetOnlyElement_two() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> CollectionUtils.getOnlyElement((Iterable)ImmutableList.of((Object)"a", (Object)"b"), xs -> new ISE("oops", new Object[0])));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"oops")));
    }

    @Test
    public void test_toMap() {
        Assert.assertEquals(Map.of("a", "A", "b", "B"), (Object)CollectionUtils.toMap(List.of("a", "b"), entry -> entry, entry -> entry.toUpperCase(Locale.ROOT)));
    }
}

