/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class NumberedPartialShardSpecTest {
    @Test
    public void testSerde() throws IOException {
        NumberedPartialShardSpec expected = NumberedPartialShardSpec.instance();
        ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();
        byte[] json = mapper.writeValueAsBytes((Object)expected);
        PartialShardSpec fromJson = (PartialShardSpec)mapper.readValue(json, PartialShardSpec.class);
        Assert.assertSame(NumberedPartialShardSpec.class, fromJson.getClass());
    }

    @Test
    public void testComplete() {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        ShardSpec shardSpec = partialShardSpec.complete(new ObjectMapper(), 1, 3);
        Assert.assertEquals((Object)new NumberedShardSpec(1, 3), (Object)shardSpec);
    }
}

