/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.util.Arrays;
import java.util.Collections;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.BuildingDimensionRangeShardSpec;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class BuildingDimensionRangeShardSpecTest {
    @Test
    public void testConvert() {
        Assert.assertEquals((Object)new DimensionRangeShardSpec(Arrays.asList("dim1", "dim2"), StringTuple.create((String[])new String[]{"start1", "start2"}), StringTuple.create((String[])new String[]{"end1", "end2"}), 5, Integer.valueOf(10)), (Object)new BuildingDimensionRangeShardSpec(1, Arrays.asList("dim1", "dim2"), StringTuple.create((String[])new String[]{"start1", "start2"}), StringTuple.create((String[])new String[]{"end1", "end2"}), 5).convert(10));
    }

    @Test
    public void testConvert_withSingleDimension() {
        Assert.assertEquals((Object)new SingleDimensionShardSpec("dim", "start", "end", 5, Integer.valueOf(10)), (Object)new BuildingDimensionRangeShardSpec(1, Collections.singletonList("dim"), StringTuple.create((String[])new String[]{"start"}), StringTuple.create((String[])new String[]{"end"}), 5).convert(10));
    }

    @Test
    public void testCreateChunk() {
        Assert.assertEquals((Object)new NumberedPartitionChunk(5, 0, (Object)"test"), (Object)new BuildingDimensionRangeShardSpec(1, Arrays.asList("dim1", "dim2"), StringTuple.create((String[])new String[]{"start1", "start2"}), StringTuple.create((String[])new String[]{"end1", "end2"}), 5).createChunk((Object)"test"));
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();
        mapper.registerSubtypes(new NamedType[]{new NamedType(BuildingDimensionRangeShardSpec.class, "building_range")});
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)mapper));
        BuildingDimensionRangeShardSpec original = new BuildingDimensionRangeShardSpec(1, Arrays.asList("dim1", "dim2"), StringTuple.create((String[])new String[]{"start1", "start2"}), StringTuple.create((String[])new String[]{"end1", "end2"}), 5);
        String json = mapper.writeValueAsString((Object)original);
        ShardSpec shardSpec = (ShardSpec)mapper.readValue(json, ShardSpec.class);
        Assert.assertEquals((Object)"building_range", (Object)shardSpec.getType());
        BuildingDimensionRangeShardSpec fromJson = (BuildingDimensionRangeShardSpec)shardSpec;
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(BuildingDimensionRangeShardSpec.class).usingGetClass().verify();
    }
}

