/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentStatusInCluster;
import org.apache.druid.timeline.TestSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SegmentStatusInClusterTest {
    private static final ObjectMapper MAPPER = SegmentStatusInClusterTest.createObjectMapper();
    private static final Interval INTERVAL = Intervals.of((String)"2011-10-01/2011-10-02");
    private static final ImmutableMap<String, Object> LOAD_SPEC = ImmutableMap.of((Object)"something", (Object)"or_other");
    private static final boolean OVERSHADOWED = true;
    private static final Integer REPLICATION_FACTOR = 2;
    private static final Long NUM_ROWS = 10L;
    private static final boolean REALTIME = true;
    private static final int TEST_VERSION = 9;
    private static final SegmentStatusInCluster SEGMENT = SegmentStatusInClusterTest.createSegmentForTest();

    private static ObjectMapper createObjectMapper() {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT);
        objectMapper.setInjectableValues((InjectableValues)injectableValues);
        return objectMapper;
    }

    private static SegmentStatusInCluster createSegmentForTest() {
        DataSegment dataSegment = DataSegment.builder((SegmentId)SegmentId.of((String)"something", (Interval)INTERVAL, (String)"1", null)).shardSpec((ShardSpec)NoneShardSpec.instance()).dimensions(Arrays.asList("dim1", "dim2")).metrics(Arrays.asList("met1", "met2")).projections(Arrays.asList("proj1", "proj2")).loadSpec(LOAD_SPEC).binaryVersion(Integer.valueOf(9)).size(1L).build();
        return new SegmentStatusInCluster(dataSegment, true, REPLICATION_FACTOR, NUM_ROWS, true);
    }

    @Test
    public void testUnwrappedSegmentWithOvershadowedStatusDeserialization() throws Exception {
        Map objectMap = (Map)MAPPER.readValue(MAPPER.writeValueAsString((Object)SEGMENT), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)15L, (long)objectMap.size());
        Assert.assertEquals((Object)"something", objectMap.get("dataSource"));
        Assert.assertEquals((Object)INTERVAL.toString(), objectMap.get("interval"));
        Assert.assertEquals((Object)"1", objectMap.get("version"));
        Assert.assertEquals(LOAD_SPEC, objectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", objectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", objectMap.get("metrics"));
        Assert.assertEquals((Object)"proj1,proj2", objectMap.get("projections"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"none"), objectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, objectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, objectMap.get("size"));
        Assert.assertEquals((Object)true, objectMap.get("overshadowed"));
        Assert.assertEquals((Object)REPLICATION_FACTOR, objectMap.get("replicationFactor"));
        Assert.assertEquals((Object)NUM_ROWS.intValue(), objectMap.get("numRows"));
        Assert.assertEquals((Object)true, objectMap.get("realtime"));
        String json = MAPPER.writeValueAsString((Object)SEGMENT);
        TestSegment deserializedSegment = (TestSegment)((Object)MAPPER.readValue(json, TestSegment.class));
        DataSegment dataSegment = SEGMENT.getDataSegment();
        Assert.assertEquals((Object)dataSegment.getDataSource(), (Object)deserializedSegment.getDataSource());
        Assert.assertEquals((Object)dataSegment.getInterval(), (Object)deserializedSegment.getInterval());
        Assert.assertEquals((Object)dataSegment.getVersion(), (Object)deserializedSegment.getVersion());
        Assert.assertEquals((Object)dataSegment.getLoadSpec(), (Object)deserializedSegment.getLoadSpec());
        Assert.assertEquals((Object)dataSegment.getDimensions(), (Object)deserializedSegment.getDimensions());
        Assert.assertEquals((Object)dataSegment.getMetrics(), (Object)deserializedSegment.getMetrics());
        Assert.assertEquals((Object)dataSegment.getProjections(), (Object)deserializedSegment.getProjections());
        Assert.assertEquals((Object)dataSegment.getShardSpec(), (Object)deserializedSegment.getShardSpec());
        Assert.assertEquals((long)dataSegment.getSize(), (long)deserializedSegment.getSize());
        Assert.assertEquals((Object)dataSegment.getId(), (Object)deserializedSegment.getId());
        Assert.assertEquals((Object)true, (Object)deserializedSegment.isOvershadowed());
        Assert.assertEquals((Object)REPLICATION_FACTOR, (Object)deserializedSegment.getReplicationFactor());
    }

    @Test
    public void testJsonCreatorAndJsonUnwrappedAnnotationsAreCompatible() throws Exception {
        String json = MAPPER.writeValueAsString((Object)SEGMENT);
        SegmentStatusInCluster segment = (SegmentStatusInCluster)MAPPER.readValue(json, SegmentStatusInCluster.class);
        Assert.assertEquals((Object)SEGMENT, (Object)segment);
        Assert.assertEquals((Object)json, (Object)MAPPER.writeValueAsString((Object)segment));
    }
}

