/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RangeSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSegmentTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final int TEST_VERSION = 9;

    private static ShardSpec getShardSpec(final int partitionNum) {
        return new ShardSpec(){

            public <T> PartitionChunk<T> createChunk(T obj) {
                return null;
            }

            public int getPartitionNum() {
                return partitionNum;
            }

            public int getNumCorePartitions() {
                return 0;
            }

            public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
                return null;
            }

            public List<String> getDomainDimensions() {
                return ImmutableList.of();
            }

            public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
                return true;
            }
        };
    }

    @Before
    public void setUp() {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT);
        MAPPER.setInjectableValues((InjectableValues)injectableValues);
    }

    @Test
    public void testSerializationWithProjections() throws Exception {
        Interval interval = Intervals.of((String)"2011-10-01/2011-10-02");
        NumberedShardSpec shardSpec = new NumberedShardSpec(3, 0);
        SegmentId segmentId = SegmentId.of((String)"something", (Interval)interval, (String)"1", (ShardSpec)shardSpec);
        ImmutableMap loadSpec = ImmutableMap.of((Object)"something", (Object)"or_other");
        CompactionState compactionState = new CompactionState((PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(100000), null, (List)ImmutableList.of((Object)"dim1")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim1", (Object)"bar", (Object)"foo"))), (List)ImmutableList.of((Object)new CountAggregatorFactory("count")), new CompactionTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null)), (IndexSpec)MAPPER.convertValue((Object)ImmutableMap.of(), IndexSpec.class), (GranularitySpec)MAPPER.convertValue((Object)ImmutableMap.of(), GranularitySpec.class), null);
        DataSegment segment = DataSegment.builder((SegmentId)segmentId).loadSpec((Map)loadSpec).dimensions(Arrays.asList("dim1", "dim2")).metrics(Arrays.asList("met1", "met2")).projections(Arrays.asList("proj1", "proj2")).shardSpec((ShardSpec)shardSpec).lastCompactionState(compactionState).binaryVersion(Integer.valueOf(9)).size(1L).build();
        Map objectMap = (Map)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)12L, (long)objectMap.size());
        Assert.assertEquals((Object)"something", objectMap.get("dataSource"));
        Assert.assertEquals((Object)interval.toString(), objectMap.get("interval"));
        Assert.assertEquals((Object)"1", objectMap.get("version"));
        Assert.assertEquals((Object)loadSpec, objectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", objectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", objectMap.get("metrics"));
        Assert.assertEquals((Object)"proj1,proj2", objectMap.get("projections"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"numbered", (Object)"partitionNum", (Object)3, (Object)"partitions", (Object)0), objectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, objectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, objectMap.get("size"));
        Assert.assertEquals((long)6L, (long)((Map)objectMap.get("lastCompactionState")).size());
        DataSegment deserializedSegment = (DataSegment)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), DataSegment.class);
        DataSegmentTest.assertAllFieldsEquals(segment, deserializedSegment);
        Assert.assertEquals((long)0L, (long)segment.compareTo(deserializedSegment));
        Assert.assertEquals((long)0L, (long)deserializedSegment.compareTo(segment));
        Assert.assertEquals((long)segment.hashCode(), (long)deserializedSegment.hashCode());
    }

    @Test
    public void testV1Serialization() throws Exception {
        Interval interval = Intervals.of((String)"2011-10-01/2011-10-02");
        ImmutableMap loadSpec = ImmutableMap.of((Object)"something", (Object)"or_other");
        DataSegment segment = new DataSegment("something", interval, "1", (Map)loadSpec, Arrays.asList("dim1", "dim2"), Arrays.asList("met1", "met2"), (ShardSpec)new NumberedShardSpec(3, 0), new CompactionState((PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(100000), null, (List)ImmutableList.of((Object)"dim1")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim1", (Object)"bar", (Object)"foo"))), (List)ImmutableList.of((Object)new CountAggregatorFactory("count")), new CompactionTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null)), (IndexSpec)MAPPER.convertValue((Object)ImmutableMap.of(), IndexSpec.class), (GranularitySpec)MAPPER.convertValue((Object)ImmutableMap.of(), GranularitySpec.class), null), Integer.valueOf(9), 1L);
        Map objectMap = (Map)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)11L, (long)objectMap.size());
        Assert.assertEquals((Object)"something", objectMap.get("dataSource"));
        Assert.assertEquals((Object)interval.toString(), objectMap.get("interval"));
        Assert.assertEquals((Object)"1", objectMap.get("version"));
        Assert.assertEquals((Object)loadSpec, objectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", objectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", objectMap.get("metrics"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"numbered", (Object)"partitionNum", (Object)3, (Object)"partitions", (Object)0), objectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, objectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, objectMap.get("size"));
        Assert.assertEquals((long)6L, (long)((Map)objectMap.get("lastCompactionState")).size());
        DataSegment deserializedSegment = (DataSegment)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), DataSegment.class);
        DataSegmentTest.assertAllFieldsEquals(segment, deserializedSegment);
        Assert.assertEquals((long)0L, (long)segment.compareTo(deserializedSegment));
        Assert.assertEquals((long)0L, (long)deserializedSegment.compareTo(segment));
        Assert.assertEquals((long)segment.hashCode(), (long)deserializedSegment.hashCode());
    }

    @Test
    public void testDeserializationDataSegmentLastCompactionStateWithNullSpecs() throws Exception {
        Interval interval = Intervals.of((String)"2011-10-01/2011-10-02");
        ImmutableMap loadSpec = ImmutableMap.of((Object)"something", (Object)"or_other");
        DataSegment segment = new DataSegment("something", interval, "1", (Map)loadSpec, Arrays.asList("dim1", "dim2"), Arrays.asList("met1", "met2"), (ShardSpec)new NumberedShardSpec(3, 0), new CompactionState((PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(100000), null, (List)ImmutableList.of((Object)"dim1")), null, null, null, (IndexSpec)MAPPER.convertValue((Object)ImmutableMap.of(), IndexSpec.class), (GranularitySpec)MAPPER.convertValue((Object)ImmutableMap.of(), GranularitySpec.class), null), Integer.valueOf(9), 1L);
        String lastCompactionStateWithNullSpecs = "{\"dataSource\": \"something\",\"interval\": \"2011-10-01T00:00:00.000Z/2011-10-02T00:00:00.000Z\",\"version\": \"1\",\"loadSpec\": { \"something\": \"or_other\"},\"dimensions\": \"dim1,dim2\",\"metrics\": \"met1,met2\",\"shardSpec\": { \"type\": \"numbered\", \"partitionNum\": 3, \"partitions\": 0},\"lastCompactionState\": { \"partitionsSpec\": {  \"type\": \"hashed\",  \"numShards\": null,  \"partitionDimensions\": [\"dim1\"],  \"partitionFunction\": \"murmur3_32_abs\",  \"maxRowsPerSegment\": 100000 }, \"indexSpec\": {}, \"granularitySpec\": {}},\"binaryVersion\": 9,\"size\": 1,\"identifier\": \"something_2011-10-01T00:00:00.000Z_2011-10-02T00:00:00.000Z_1_3\"}";
        Map objectMap = (Map)MAPPER.readValue(lastCompactionStateWithNullSpecs, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)11L, (long)objectMap.size());
        Assert.assertEquals((Object)"something", objectMap.get("dataSource"));
        Assert.assertEquals((Object)interval.toString(), objectMap.get("interval"));
        Assert.assertEquals((Object)"1", objectMap.get("version"));
        Assert.assertEquals((Object)loadSpec, objectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", objectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", objectMap.get("metrics"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"numbered", (Object)"partitionNum", (Object)3, (Object)"partitions", (Object)0), objectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, objectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, objectMap.get("size"));
        Assert.assertEquals((long)3L, (long)((Map)objectMap.get("lastCompactionState")).size());
        DataSegment deserializedSegment = (DataSegment)MAPPER.readValue(lastCompactionStateWithNullSpecs, DataSegment.class);
        DataSegmentTest.assertAllFieldsEquals(segment, deserializedSegment);
        Assert.assertNotNull((Object)segment.getLastCompactionState());
        Assert.assertNull((Object)segment.getLastCompactionState().getDimensionsSpec());
        Assert.assertNull((Object)segment.getLastCompactionState().getTransformSpec());
        Assert.assertNull((Object)segment.getLastCompactionState().getMetricsSpec());
        Assert.assertNotNull((Object)deserializedSegment.getLastCompactionState());
        Assert.assertNull((Object)deserializedSegment.getLastCompactionState().getDimensionsSpec());
        Assert.assertEquals((long)0L, (long)segment.compareTo(deserializedSegment));
        Assert.assertEquals((long)0L, (long)deserializedSegment.compareTo(segment));
        Assert.assertEquals((long)segment.hashCode(), (long)deserializedSegment.hashCode());
    }

    @Test
    public void testIdentifier() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec((ShardSpec)NoneShardSpec.instance()).size(0L).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z", (Object)segment.getId().toString());
    }

    @Test
    public void testIdentifierWithZeroPartition() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(0)).size(0L).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z", (Object)segment.getId().toString());
    }

    @Test
    public void testIdentifierWithNonzeroPartition() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(7)).size(0L).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z_7", (Object)segment.getId().toString());
    }

    @Test
    public void testV1SerializationNullMetrics() throws Exception {
        DataSegment segment = DataSegment.builder((SegmentId)SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2012-01-01/2012-01-02"), (String)DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString(), null)).size(1L).build();
        DataSegment segment2 = (DataSegment)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((String)"empty dimensions", (Object)ImmutableList.of(), (Object)segment2.getDimensions());
        Assert.assertEquals((String)"empty metrics", (Object)ImmutableList.of(), (Object)segment2.getMetrics());
    }

    @Test
    public void testWithLastCompactionState() {
        CompactionState compactionState = new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(null, null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), (List)ImmutableList.of((Object)new CountAggregatorFactory("count")), new CompactionTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null)), (IndexSpec)MAPPER.convertValue(Map.of("test", "map"), IndexSpec.class), (GranularitySpec)MAPPER.convertValue(Map.of("test2", "map2"), GranularitySpec.class), null);
        DataSegment segment1 = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(7)).size(0L).lastCompactionState(compactionState).build();
        DataSegment segment2 = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(7)).size(0L).build();
        Assert.assertEquals((Object)segment1, (Object)segment2.withLastCompactionState(compactionState));
    }

    @Test
    public void testAnnotateWithLastCompactionState() {
        DynamicPartitionsSpec dynamicPartitionsSpec = new DynamicPartitionsSpec(null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo")));
        ImmutableList metricsSpec = ImmutableList.of((Object)new CountAggregatorFactory("count"));
        CompactionTransformSpec transformSpec = new CompactionTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null));
        IndexSpec indexSpec = (IndexSpec)MAPPER.convertValue(Map.of("test", "map"), IndexSpec.class);
        GranularitySpec granularitySpec = (GranularitySpec)MAPPER.convertValue(Map.of("test2", "map"), GranularitySpec.class);
        CompactionState compactionState = new CompactionState((PartitionsSpec)dynamicPartitionsSpec, dimensionsSpec, (List)metricsSpec, transformSpec, indexSpec, granularitySpec, null);
        Function addCompactionStateFunction = CompactionState.addCompactionStateToSegments((PartitionsSpec)dynamicPartitionsSpec, (DimensionsSpec)dimensionsSpec, (List)metricsSpec, (CompactionTransformSpec)transformSpec, (IndexSpec)indexSpec, (GranularitySpec)granularitySpec, (List)ImmutableList.of());
        DataSegment segment1 = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(7)).size(0L).lastCompactionState(compactionState).build();
        DataSegment segment2 = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(7)).size(0L).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)segment1), addCompactionStateFunction.apply(ImmutableSet.of((Object)segment2)));
    }

    @Test
    public void testTombstoneType() {
        DataSegment segment1 = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec((ShardSpec)new TombstoneShardSpec()).loadSpec(Map.of("type", "tombstone")).size(0L).build();
        Assert.assertTrue((boolean)segment1.isTombstone());
        Assert.assertFalse((boolean)segment1.hasData());
        DataSegment segment2 = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(7)).loadSpec(Map.of("type", "foo")).size(0L).build();
        Assert.assertFalse((boolean)segment2.isTombstone());
        Assert.assertTrue((boolean)segment2.hasData());
        DataSegment segment3 = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(7)).size(0L).build();
        Assert.assertFalse((boolean)segment3.isTombstone());
        Assert.assertTrue((boolean)segment3.hasData());
    }

    private static void assertAllFieldsEquals(DataSegment segment1, DataSegment segment2) {
        Assert.assertEquals((Object)segment1.getDataSource(), (Object)segment2.getDataSource());
        Assert.assertEquals((Object)segment1.getInterval(), (Object)segment2.getInterval());
        Assert.assertEquals((Object)segment1.getVersion(), (Object)segment2.getVersion());
        Assert.assertEquals((Object)segment1.getLoadSpec(), (Object)segment2.getLoadSpec());
        Assert.assertEquals((Object)segment1.getDimensions(), (Object)segment2.getDimensions());
        Assert.assertEquals((Object)segment1.getMetrics(), (Object)segment2.getMetrics());
        Assert.assertEquals((Object)segment1.getProjections(), (Object)segment2.getProjections());
        Assert.assertEquals((Object)segment1.getShardSpec(), (Object)segment2.getShardSpec());
        Assert.assertEquals((long)segment1.getSize(), (long)segment2.getSize());
        Assert.assertEquals((Object)segment1.getBinaryVersion(), (Object)segment2.getBinaryVersion());
        Assert.assertEquals((Object)segment1.getId(), (Object)segment2.getId());
        Assert.assertEquals((Object)segment1.getLastCompactionState(), (Object)segment2.getLastCompactionState());
    }
}

