/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.RegexFilteredVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class RegexFilteredVirtualColumnTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        RegexFilteredVirtualColumn virtualColumn = new RegexFilteredVirtualColumn("hello", (DimensionSpec)new DefaultDimensionSpec("column", "output", ColumnType.STRING), "^.*abc$");
        RegexFilteredVirtualColumn roundTrip = (RegexFilteredVirtualColumn)MAPPER.readValue(MAPPER.writeValueAsString((Object)virtualColumn), RegexFilteredVirtualColumn.class);
        Assert.assertEquals((Object)virtualColumn, (Object)roundTrip);
        Assert.assertArrayEquals((byte[])virtualColumn.getCacheKey(), (byte[])roundTrip.getCacheKey());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(RegexFilteredVirtualColumn.class).usingGetClass().verify();
    }
}

