/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.PrefixFilteredVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class PrefixFilteredVirtualColumnTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        PrefixFilteredVirtualColumn virtualColumn = new PrefixFilteredVirtualColumn("hello", (DimensionSpec)new DefaultDimensionSpec("column", "output", ColumnType.STRING), "a");
        PrefixFilteredVirtualColumn roundTrip = (PrefixFilteredVirtualColumn)MAPPER.readValue(MAPPER.writeValueAsString((Object)virtualColumn), PrefixFilteredVirtualColumn.class);
        Assert.assertEquals((Object)virtualColumn, (Object)roundTrip);
        Assert.assertArrayEquals((byte[])virtualColumn.getCacheKey(), (byte[])roundTrip.getCacheKey());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(PrefixFilteredVirtualColumn.class).usingGetClass().verify();
    }
}

