/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.virtual.NestedMergeVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class NestedMergeVirtualColumnTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        NestedMergeVirtualColumn there = new NestedMergeVirtualColumn("merged", (List)ImmutableList.of((Object)"col1", (Object)"col2", (Object)"col3"), TestExprMacroTable.INSTANCE);
        String json = JSON_MAPPER.writeValueAsString((Object)there);
        NestedMergeVirtualColumn andBackAgain = (NestedMergeVirtualColumn)JSON_MAPPER.readValue(json, NestedMergeVirtualColumn.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
    }

    @Test
    public void testSerdeWithSingleColumn() throws JsonProcessingException {
        NestedMergeVirtualColumn there = new NestedMergeVirtualColumn("merged", (List)ImmutableList.of((Object)"singleCol"), TestExprMacroTable.INSTANCE);
        String json = JSON_MAPPER.writeValueAsString((Object)there);
        NestedMergeVirtualColumn andBackAgain = (NestedMergeVirtualColumn)JSON_MAPPER.readValue(json, NestedMergeVirtualColumn.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
    }

    @Test
    public void testGetColumns() {
        NestedMergeVirtualColumn column = new NestedMergeVirtualColumn("merged", Arrays.asList("col1", "col2", "col3"), TestExprMacroTable.INSTANCE);
        Assert.assertEquals(Arrays.asList("col1", "col2", "col3"), (Object)column.getColumns());
    }

    @Test
    public void testEquivalence() {
        NestedMergeVirtualColumn v1 = new NestedMergeVirtualColumn("merged1", Arrays.asList("col1", "col2"), TestExprMacroTable.INSTANCE);
        NestedMergeVirtualColumn v2 = new NestedMergeVirtualColumn("merged2", Arrays.asList("col1", "col2"), TestExprMacroTable.INSTANCE);
        NestedMergeVirtualColumn v3 = new NestedMergeVirtualColumn("merged1", Arrays.asList("col1", "col3"), TestExprMacroTable.INSTANCE);
        Assert.assertNotEquals((Object)v1, (Object)v2);
        Assert.assertEquals((Object)v1.getEquivalanceKey(), (Object)v2.getEquivalanceKey());
        Assert.assertNotEquals((Object)v1, (Object)v3);
        Assert.assertNotEquals((Object)v1.getEquivalanceKey(), (Object)v3.getEquivalanceKey());
    }

    @Test
    public void testToString() {
        NestedMergeVirtualColumn column = new NestedMergeVirtualColumn("merged", Arrays.asList("col1", "col2"), TestExprMacroTable.INSTANCE);
        String expected = "NestedMergeVirtualColumn{name='merged', columns=[col1, col2]}";
        Assert.assertEquals((Object)expected, (Object)column.toString());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(NestedMergeVirtualColumn.class).withNonnullFields(new String[]{"columns"}).usingGetClass().verify();
    }
}

