/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junitparams.converters.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.QueryableIndexVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class QueryableIndexVectorColumnSelectorFactoryTest
extends InitializedNullHandlingTest {
    private static final String TS = "t";
    private static final String STRING = "string_column";
    private static final String MULTI_STRING = "multi_string_column";
    private static final String DOUBLE = "double_column";
    private static final String FLOAT = "float_column";
    private static final String LONG = "long_column";
    private static final List<Map<String, Object>> RAW_ROWS = ImmutableList.of(QueryableIndexVectorColumnSelectorFactoryTest.makeRow("2022-01-01T00:00Z", "a", "aa", 1.0, Float.valueOf(1.0f), 1L), QueryableIndexVectorColumnSelectorFactoryTest.makeRow("2022-01-01T00:01Z", "b", ImmutableList.of((Object)"bb", (Object)"cc"), null, Float.valueOf(3.3f), 1999L), QueryableIndexVectorColumnSelectorFactoryTest.makeRow("2022-01-01T00:02Z", null, ImmutableList.of((Object)"aa", (Object)"dd"), 9.9, null, -500L), QueryableIndexVectorColumnSelectorFactoryTest.makeRow("2022-01-01T00:03Z", "c", ImmutableList.of((Object)"dd", (Object)"ee"), -1.1, Float.valueOf(-999.999f), null), QueryableIndexVectorColumnSelectorFactoryTest.makeRow("2022-01-01T00:04Z", "d", ImmutableList.of((Object)"aa", (Object)"ff"), -90998.132, Float.valueOf(1234.5677f), 1234L), QueryableIndexVectorColumnSelectorFactoryTest.makeRow("2022-01-01T00:05Z", "e", null, 3.3, Float.valueOf(11.0f), -9000L));
    private static final DimensionsSpec DIMS = new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("string_column"), (Object)new StringDimensionSchema("multi_string_column"), (Object)new DoubleDimensionSchema("double_column"), (Object)new FloatDimensionSchema("float_column"), (Object)new LongDimensionSchema("long_column")));
    private static final MapInputRowParser OLD_SCHOOL = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("t", "iso", null), DIMS));
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    Closer closer;
    ColumnCache theCache;
    QueryableIndex index;

    private static Map<String, Object> makeRow(Object t, @Nullable Object str, @Nullable Object mStr, @Nullable Object d, @Nullable Object f, @Nullable Object l) {
        HashMap row = Maps.newHashMapWithExpectedSize((int)6);
        row.put(TS, t);
        if (str != null) {
            row.put(STRING, str);
        }
        if (mStr != null) {
            row.put(MULTI_STRING, mStr);
        }
        if (d != null) {
            row.put(DOUBLE, d);
        }
        if (f != null) {
            row.put(FLOAT, f);
        }
        if (l != null) {
            row.put(LONG, l);
        }
        return row;
    }

    @Before
    public void setup() throws IOException {
        this.closer = Closer.create();
        this.index = IndexBuilder.create(TestHelper.makeJsonMapper()).tmpDir(this.temporaryFolder.newFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withDimensionsSpec(DIMS).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).withRollup(false).build()).rows(((Stream)RAW_ROWS.stream().sequential()).map(r -> (InputRow)OLD_SCHOOL.parseBatch(r).get(0)).collect(Collectors.toList())).buildMMappedIndex();
        this.closer.register((Closeable)this.index);
        this.theCache = new ColumnCache(this.index, VirtualColumns.EMPTY, this.closer);
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testSingleValueSelector() {
        NoFilterVectorOffset offset = new NoFilterVectorOffset(4, 0, RAW_ROWS.size());
        QueryableIndexVectorColumnSelectorFactory factory = new QueryableIndexVectorColumnSelectorFactory((ReadableVectorOffset)offset, (ColumnSelector)this.theCache, VirtualColumns.EMPTY);
        Assert.assertThrows(ISE.class, () -> factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)MULTI_STRING)));
        Assert.assertTrue((boolean)(factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)DOUBLE)) instanceof NilVectorSelector));
        Assert.assertTrue((boolean)(factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)FLOAT)) instanceof NilVectorSelector));
        Assert.assertTrue((boolean)(factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)LONG)) instanceof NilVectorSelector));
        SingleValueDimensionVectorSelector vectorSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)STRING));
        VectorObjectSelector objectSelector = factory.makeObjectSelector(STRING);
        int rowCounter = 0;
        while (!offset.isDone()) {
            int[] ints = vectorSelector.getRowVector();
            Assert.assertNotNull((Object)ints);
            for (int i = 0; i < vectorSelector.getCurrentVectorSize(); ++i) {
                Assert.assertEquals((Object)RAW_ROWS.get(rowCounter + i).get(STRING), (Object)vectorSelector.lookupName(ints[i]));
            }
            Object[] objects = objectSelector.getObjectVector();
            for (int i = 0; i < vectorSelector.getCurrentVectorSize(); ++i) {
                Assert.assertEquals((String)("row " + i), (Object)RAW_ROWS.get(rowCounter + i).get(STRING), (Object)objects[i]);
            }
            rowCounter += objectSelector.getCurrentVectorSize();
            offset.advance();
        }
    }

    @Test
    public void testMultiValueSelector() {
        NoFilterVectorOffset offset = new NoFilterVectorOffset(4, 0, RAW_ROWS.size());
        QueryableIndexVectorColumnSelectorFactory factory = new QueryableIndexVectorColumnSelectorFactory((ReadableVectorOffset)offset, (ColumnSelector)this.theCache, VirtualColumns.EMPTY);
        Assert.assertThrows(ISE.class, () -> factory.makeMultiValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)STRING)));
        Assert.assertThrows(ISE.class, () -> factory.makeMultiValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)DOUBLE)));
        Assert.assertThrows(ISE.class, () -> factory.makeMultiValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)FLOAT)));
        Assert.assertThrows(ISE.class, () -> factory.makeMultiValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)LONG)));
        MultiValueDimensionVectorSelector vectorSelector = factory.makeMultiValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)MULTI_STRING));
        VectorObjectSelector objectSelector = factory.makeObjectSelector(MULTI_STRING);
        int rowCounter = 0;
        while (!offset.isDone()) {
            IndexedInts[] indexedInts = vectorSelector.getRowVector();
            Assert.assertNotNull((Object)indexedInts);
            for (int i = 0; i < vectorSelector.getCurrentVectorSize(); ++i) {
                IndexedInts currentRow = indexedInts[i];
                if (currentRow.size() == 0) {
                    Assert.assertNull((Object)RAW_ROWS.get(rowCounter + i).get(MULTI_STRING));
                    continue;
                }
                if (currentRow.size() == 1) {
                    Assert.assertEquals((Object)RAW_ROWS.get(rowCounter + i).get(MULTI_STRING), (Object)vectorSelector.lookupName(currentRow.get(0)));
                    continue;
                }
                for (int j = 0; j < currentRow.size(); ++j) {
                    List expected = (List)RAW_ROWS.get(rowCounter + i).get(MULTI_STRING);
                    Assert.assertEquals(expected.get(j), (Object)vectorSelector.lookupName(currentRow.get(j)));
                }
            }
            Object[] objects = objectSelector.getObjectVector();
            for (int i = 0; i < vectorSelector.getCurrentVectorSize(); ++i) {
                Assert.assertEquals((String)("row " + i), (Object)RAW_ROWS.get(rowCounter + i).get(MULTI_STRING), (Object)objects[i]);
            }
            rowCounter += objectSelector.getCurrentVectorSize();
            offset.advance();
        }
    }

    @Test
    public void testNumericSelectors() {
        NoFilterVectorOffset offset = new NoFilterVectorOffset(4, 0, RAW_ROWS.size());
        QueryableIndexVectorColumnSelectorFactory factory = new QueryableIndexVectorColumnSelectorFactory((ReadableVectorOffset)offset, (ColumnSelector)this.theCache, VirtualColumns.EMPTY);
        Assert.assertThrows(UOE.class, () -> factory.makeValueSelector(STRING));
        Assert.assertThrows(UOE.class, () -> factory.makeValueSelector(MULTI_STRING));
        VectorValueSelector doubleSelector = factory.makeValueSelector(DOUBLE);
        VectorValueSelector floatSelector = factory.makeValueSelector(FLOAT);
        VectorValueSelector longSelector = factory.makeValueSelector(LONG);
        int rowCounter = 0;
        while (!offset.isDone()) {
            double[] doubles = doubleSelector.getDoubleVector();
            boolean[] doubleNulls = doubleSelector.getNullVector();
            for (int i = 0; i < doubleSelector.getCurrentVectorSize(); ++i) {
                Object raw = RAW_ROWS.get(rowCounter + i).get(DOUBLE);
                if (doubleNulls != null && doubleNulls[i]) {
                    Assert.assertNull((Object)raw);
                    continue;
                }
                if (raw == null) {
                    Assert.assertEquals((double)0.0, (double)doubles[i], (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)((Double)raw), (double)doubles[i], (double)0.0);
            }
            float[] floats = floatSelector.getFloatVector();
            boolean[] floatNulls = floatSelector.getNullVector();
            for (int i = 0; i < floatSelector.getCurrentVectorSize(); ++i) {
                Object raw = RAW_ROWS.get(rowCounter + i).get(FLOAT);
                if (floatNulls != null && floatNulls[i]) {
                    Assert.assertNull((Object)raw);
                    continue;
                }
                if (raw == null) {
                    Assert.assertEquals((double)0.0, (double)floats[i], (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)((Float)raw).floatValue(), (double)floats[i], (double)0.0);
            }
            long[] longs = longSelector.getLongVector();
            boolean[] longNulls = longSelector.getNullVector();
            for (int i = 0; i < longSelector.getCurrentVectorSize(); ++i) {
                Object raw = RAW_ROWS.get(rowCounter + i).get(LONG);
                if (longNulls != null && longNulls[i]) {
                    Assert.assertNull((Object)raw);
                    continue;
                }
                if (raw == null) {
                    Assert.assertEquals((double)0.0, (double)longs[i], (double)0.0);
                    continue;
                }
                Assert.assertEquals((long)((Long)raw), (long)longs[i]);
            }
            rowCounter += doubleSelector.getCurrentVectorSize();
            offset.advance();
        }
    }
}

