/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.shim;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.SimpleQueryableIndex;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.shim.ShimCursor;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.runners.Parameterized;

public class ShimCursorTest {
    private Closer closer;

    @Parameterized.Parameters
    public static Collection<Object> vectorSizes() {
        return List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(7), Integer.valueOf(512));
    }

    @BeforeEach
    void setUp() {
        this.closer = Closer.create();
    }

    @AfterEach
    void tearDown() throws IOException {
        this.closer.close();
    }

    @ParameterizedTest(name="vectorSize = {0}")
    @MethodSource(value={"vectorSizes"})
    public void testNumberColumns(int vectorSize) {
        IncrementalIndex incrementalIndex = (IncrementalIndex)this.closer.register((Closeable)new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(true).setIncludeAllDimensions(true).setDimensions(List.of(new AutoTypeColumnSchema("A", null, null), new AutoTypeColumnSchema("B", ColumnType.DOUBLE, null), new AutoTypeColumnSchema("C", null, null))).build()).withRollup(false).build()).build());
        List<String> signature = List.of("A", "B", "C");
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 1, 2.0, 3));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 4, 5, 6));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, null, 423, 13));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 51, 0, null));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 51, -1.0, 4));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 123, 413.132, 2));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 0, null, 331));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, Long.MAX_VALUE, Float.valueOf(-824.0f), Long.MIN_VALUE));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, -1, -2.0, 112));
        SimpleQueryableIndex index = (SimpleQueryableIndex)this.closer.register((Closeable)((SimpleQueryableIndex)TestIndex.persistAndMemoryMap(incrementalIndex)));
        QueryableIndexCursorFactory queryableIndexCursorFactory = new QueryableIndexCursorFactory((QueryableIndex)index);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setQueryContext(QueryContext.of(Map.of("vectorSize", vectorSize))).build();
        CursorHolder cursorHolder = (CursorHolder)this.closer.register((Closeable)queryableIndexCursorFactory.makeCursorHolder(cursorBuildSpec));
        Assertions.assertTrue((boolean)cursorHolder.canVectorize());
        VectorCursor vectorCursor = cursorHolder.asVectorCursor();
        Cursor cursor = cursorHolder.asCursor();
        ShimCursor shimCursor = new ShimCursor(vectorCursor);
        ShimCursorTest.compareCursors(List.of("A", "B", "C", "non-existent"), cursor, shimCursor);
    }

    @ParameterizedTest(name="vectorSize = {0}")
    @MethodSource(value={"vectorSizes"})
    public void testDictionaryColumns(int vectorSize) {
        IncrementalIndex incrementalIndex = (IncrementalIndex)this.closer.register((Closeable)new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(false).setIncludeAllDimensions(true).setDimensions(List.of(new AutoTypeColumnSchema("A", null, null), new AutoTypeColumnSchema("B", ColumnType.DOUBLE, null), new AutoTypeColumnSchema("C", null, null), new AutoTypeColumnSchema("D", null, null), new AutoTypeColumnSchema("E", null, null), new AutoTypeColumnSchema("F", null, null))).build()).withRollup(false).build()).build());
        List<String> signature = List.of("A", "B", "C", "D", "E", "F");
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 1, 1.0, "Tom", ShimCursorTest.arr("Bat", "Knife"), ShimCursorTest.obj("A", "B"), null));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 2, 2.0, "Bob", ShimCursorTest.arr("Builder", "Carpenter"), ShimCursorTest.obj("A", "B"), null));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 3, 4.0, "Jack", ShimCursorTest.arr("A", "B"), ShimCursorTest.obj("Jacky", "Bobby"), null));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 4, 8.0, "Will", ShimCursorTest.arr("Sing", "Dance"), ShimCursorTest.obj("Sing", "B"), null));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 5, 16.0, "Smith", ShimCursorTest.arr("Car", "Trunk"), ShimCursorTest.obj(new Object[0]), null));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 6, -1, "Cat", ShimCursorTest.arr(new Object[0]), ShimCursorTest.obj("Bat", "Knife"), null));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 7, -2.0, "Drew", ShimCursorTest.arr("Machine", "Rabbit"), ShimCursorTest.obj("bat", "knife"), null));
        SimpleQueryableIndex index = (SimpleQueryableIndex)this.closer.register((Closeable)((SimpleQueryableIndex)TestIndex.persistAndMemoryMap(incrementalIndex)));
        QueryableIndexCursorFactory queryableIndexCursorFactory = new QueryableIndexCursorFactory((QueryableIndex)index);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setQueryContext(QueryContext.of(Map.of("vectorSize", vectorSize))).build();
        CursorHolder cursorHolder = (CursorHolder)this.closer.register((Closeable)queryableIndexCursorFactory.makeCursorHolder(cursorBuildSpec));
        Assertions.assertTrue((boolean)cursorHolder.canVectorize());
        VectorCursor vectorCursor = cursorHolder.asVectorCursor();
        Cursor cursor = cursorHolder.asCursor();
        ShimCursor shimCursor = new ShimCursor(vectorCursor);
        ShimCursorTest.compareCursors(signature, cursor, shimCursor);
    }

    @ParameterizedTest(name="vectorSize = {0}")
    @MethodSource(value={"vectorSizes"})
    public void testMultiDimColumns(int vectorSize) {
        IncrementalIndex incrementalIndex = (IncrementalIndex)this.closer.register((Closeable)new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(false).setIncludeAllDimensions(true).build()).withRollup(false).build()).build());
        List<String> signature = List.of("A", "B");
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 1, ShimCursorTest.arr("Bat", "Knife")));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 2, ShimCursorTest.arr("Builder", "Carpenter")));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 3, ShimCursorTest.arr("A", "B")));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 4, ShimCursorTest.arr("Sing", "Dance")));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 5, ShimCursorTest.arr("Car", "Trunk")));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 6, ShimCursorTest.arr(new Object[0])));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 7, ShimCursorTest.arr("Machine", "Rabbit")));
        SimpleQueryableIndex index = (SimpleQueryableIndex)this.closer.register((Closeable)((SimpleQueryableIndex)TestIndex.persistAndMemoryMap(incrementalIndex)));
        QueryableIndexCursorFactory queryableIndexCursorFactory = new QueryableIndexCursorFactory((QueryableIndex)index);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setQueryContext(QueryContext.of(Map.of("vectorSize", vectorSize))).build();
        CursorHolder cursorHolder = (CursorHolder)this.closer.register((Closeable)queryableIndexCursorFactory.makeCursorHolder(cursorBuildSpec));
        Assertions.assertTrue((boolean)cursorHolder.canVectorize());
        VectorCursor vectorCursor = cursorHolder.asVectorCursor();
        Cursor cursor = cursorHolder.asCursor();
        ShimCursor shimCursor = new ShimCursor(vectorCursor);
        ShimCursorTest.compareCursors(signature, cursor, shimCursor);
    }

    @ParameterizedTest(name="Non dict-encoded string columns with vector size {0}")
    @MethodSource(value={"vectorSizes"})
    public void testNonDictStringColumns(int vectorSize) {
        IncrementalIndex incrementalIndex = (IncrementalIndex)this.closer.register((Closeable)new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(false).setIncludeAllDimensions(true).build()).withVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(\"A\", \"B\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)})).withRollup(false).build()).build());
        List<String> signature = List.of("A", "B");
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 1, "Tom"));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 2, "Bob"));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 3, "Jack"));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 4, "Will"));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 5, "Smith"));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 6, "Cat"));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, 7, "Drew"));
        SimpleQueryableIndex index = (SimpleQueryableIndex)this.closer.register((Closeable)((SimpleQueryableIndex)TestIndex.persistAndMemoryMap(incrementalIndex)));
        QueryableIndexCursorFactory queryableIndexCursorFactory = new QueryableIndexCursorFactory((QueryableIndex)index);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setQueryContext(QueryContext.of(Map.of("vectorSize", vectorSize))).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(\"A\", \"B\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)})).build();
        CursorHolder cursorHolder = (CursorHolder)this.closer.register((Closeable)queryableIndexCursorFactory.makeCursorHolder(cursorBuildSpec));
        Assertions.assertTrue((boolean)cursorHolder.canVectorize());
        VectorCursor vectorCursor = cursorHolder.asVectorCursor();
        Cursor cursor = cursorHolder.asCursor();
        ShimCursor shimCursor = new ShimCursor(vectorCursor);
        ShimCursorTest.compareCursors(List.of("A", "B", "v0"), cursor, shimCursor);
    }

    @ParameterizedTest(name="vectorSize = {0}")
    @MethodSource(value={"vectorSizes"})
    public void testArrayColumns(int vectorSize) {
        IncrementalIndex incrementalIndex = (IncrementalIndex)this.closer.register((Closeable)new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(false).setIncludeAllDimensions(false).setDimensions(List.of(new AutoTypeColumnSchema("longArr", ColumnType.LONG_ARRAY, null), new AutoTypeColumnSchema("doubleArr", ColumnType.DOUBLE_ARRAY, null), new AutoTypeColumnSchema("stringArr", ColumnType.STRING_ARRAY, null))).build()).withRollup(false).build()).build());
        List<String> signature = List.of("longArr", "doubleArr", "stringArr");
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, ShimCursorTest.arr(2L, 3L), ShimCursorTest.arr(2.2, 3.2), ShimCursorTest.arr("a", "b")));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, null, null, null));
        incrementalIndex.add((InputRow)ShimCursorTest.autoRow(signature, ShimCursorTest.arr(4L), ShimCursorTest.arr(4.2), ShimCursorTest.arr("c")));
        SimpleQueryableIndex index = (SimpleQueryableIndex)this.closer.register((Closeable)((SimpleQueryableIndex)TestIndex.persistAndMemoryMap(incrementalIndex)));
        QueryableIndexCursorFactory queryableIndexCursorFactory = new QueryableIndexCursorFactory((QueryableIndex)index);
        CursorBuildSpec cursorBuildSpec = CursorBuildSpec.builder().setQueryContext(QueryContext.of(Map.of("vectorSize", vectorSize))).build();
        CursorHolder cursorHolder = (CursorHolder)this.closer.register((Closeable)queryableIndexCursorFactory.makeCursorHolder(cursorBuildSpec));
        Assertions.assertTrue((boolean)cursorHolder.canVectorize());
        VectorCursor vectorCursor = cursorHolder.asVectorCursor();
        Cursor cursor = cursorHolder.asCursor();
        ShimCursor shimCursor = new ShimCursor(vectorCursor);
        ShimCursorTest.compareCursors(signature, cursor, shimCursor);
    }

    private static List<Object> arr(Object ... vals) {
        return Arrays.asList(vals);
    }

    private static Map<String, Object> obj(Object ... vals) {
        if (vals.length % 2 != 0) {
            throw new ISE("vals.length[%d] needs to be a multiple of 2", new Object[]{vals.length});
        }
        LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>();
        for (int i = 0; i < vals.length; i += 2) {
            retVal.put((String)vals[i], vals[i + 1]);
        }
        return retVal;
    }

    private static void compareCursors(List<String> signature, Cursor expectedCursor, ShimCursor actualCursor) {
        HashMap<String, ColumnCapabilities> capabilitiesMap = new HashMap<String, ColumnCapabilities>();
        ColumnSelectorFactory expectedFactory = expectedCursor.getColumnSelectorFactory();
        ColumnSelectorFactory actualFactory = actualCursor.getColumnSelectorFactory();
        for (String columnName : signature) {
            ColumnCapabilities expectedCapabilities = expectedFactory.getColumnCapabilities(columnName);
            ColumnCapabilities actualCapabilities = actualFactory.getColumnCapabilities(columnName);
            ShimCursorTest.compareCapabilities(columnName, expectedCapabilities, actualCapabilities);
            capabilitiesMap.put(columnName, expectedCapabilities);
        }
        HashMap<String, DimensionSelector> expectedDimensionSelectors = new HashMap<String, DimensionSelector>();
        HashMap<String, DimensionSelector> actualDimensionSelectors = new HashMap<String, DimensionSelector>();
        HashMap<String, ColumnValueSelector> expectedValueSelectors = new HashMap<String, ColumnValueSelector>();
        HashMap<String, ColumnValueSelector> actualValueSelectors = new HashMap<String, ColumnValueSelector>();
        for (String columnName : signature) {
            if (ShimCursorTest.shouldTestDimensionSelector((ColumnCapabilities)capabilitiesMap.get(columnName))) {
                expectedDimensionSelectors.put(columnName, expectedFactory.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(columnName, columnName)));
                actualDimensionSelectors.put(columnName, actualFactory.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(columnName, columnName)));
            }
            expectedValueSelectors.put(columnName, expectedFactory.makeColumnValueSelector(columnName));
            actualValueSelectors.put(columnName, actualFactory.makeColumnValueSelector(columnName));
        }
        while (!expectedCursor.isDone()) {
            Assertions.assertFalse((boolean)actualCursor.isDone());
            for (String columnName : signature) {
                ColumnCapabilities capabilities = (ColumnCapabilities)capabilitiesMap.get(columnName);
                ShimCursorTest.compareColumnValueSelector(columnName, capabilities, (ColumnValueSelector)expectedValueSelectors.get(columnName), (ColumnValueSelector)actualValueSelectors.get(columnName));
                if (!ShimCursorTest.shouldTestDimensionSelector(capabilities)) continue;
                ShimCursorTest.compareDimensionSelector(columnName, (DimensionSelector)expectedDimensionSelectors.get(columnName), (DimensionSelector)actualDimensionSelectors.get(columnName));
            }
            expectedCursor.advance();
            actualCursor.advance();
        }
        Assertions.assertTrue((boolean)actualCursor.isDone());
    }

    private static boolean shouldTestDimensionSelector(ColumnCapabilities capabilities) {
        return capabilities == null || !capabilities.is((TypeDescriptor)ValueType.ARRAY);
    }

    private static void compareCapabilities(String columnName, @Nullable ColumnCapabilities expectedCapabilities, @Nullable ColumnCapabilities actualCapabilities) {
        Assertions.assertEquals((Object)(expectedCapabilities != null ? 1 : 0), (Object)(actualCapabilities != null ? 1 : 0), (String)("presence of capabilities for " + columnName));
        if (expectedCapabilities == null) {
            return;
        }
        Assertions.assertEquals((Object)expectedCapabilities.getType(), (Object)actualCapabilities.getType(), (String)("type of " + columnName));
        Assertions.assertEquals((Object)expectedCapabilities.getElementType(), (Object)actualCapabilities.getElementType(), (String)("elementType of " + columnName));
        Assertions.assertEquals((Object)expectedCapabilities.getComplexTypeName(), (Object)actualCapabilities.getComplexTypeName(), (String)("complexTypeName of " + columnName));
        Assertions.assertEquals((Object)expectedCapabilities.isDictionaryEncoded(), (Object)actualCapabilities.isDictionaryEncoded(), (String)("dictionaryEncoded of " + columnName));
        Assertions.assertEquals((Object)expectedCapabilities.areDictionaryValuesUnique(), (Object)actualCapabilities.areDictionaryValuesUnique(), (String)("areDictionaryValuesUnique of " + columnName));
        Assertions.assertEquals((Object)expectedCapabilities.areDictionaryValuesSorted(), (Object)actualCapabilities.areDictionaryValuesSorted(), (String)("areDictionaryValuesSorted of " + columnName));
        Assertions.assertEquals((Object)expectedCapabilities.hasNulls(), (Object)actualCapabilities.hasNulls(), (String)("hasNulls of " + columnName));
        Assertions.assertEquals((Object)expectedCapabilities.hasMultipleValues(), (Object)actualCapabilities.hasMultipleValues(), (String)("hasMultipleValues of " + columnName));
    }

    private static void compareColumnValueSelector(String columnName, ColumnCapabilities capabilities, ColumnValueSelector<?> expectedSelector, ColumnValueSelector<?> actualSelector) {
        if (capabilities != null && capabilities.isNumeric()) {
            Assertions.assertEquals((long)expectedSelector.getLong(), (long)actualSelector.getLong(), (String)("getLong for " + columnName));
            Assertions.assertEquals((double)expectedSelector.getDouble(), (double)actualSelector.getDouble(), (String)("getDouble for " + columnName));
            Assertions.assertEquals((float)expectedSelector.getFloat(), (float)actualSelector.getFloat(), (String)("getFloat for " + columnName));
            Assertions.assertEquals((Object)expectedSelector.isNull(), (Object)actualSelector.isNull(), (String)("isNull for " + columnName));
        }
        Object expectedObject = expectedSelector.getObject();
        Object actualObject = actualSelector.getObject();
        if (expectedObject instanceof Object[]) {
            MatcherAssert.assertThat((String)("type of getObject for " + columnName), (Object)actualObject, (Matcher)CoreMatchers.instanceOf(Object[].class));
            Assertions.assertArrayEquals((Object[])((Object[])expectedObject), (Object[])((Object[])actualObject), (String)("getObject for " + columnName));
        } else {
            Assertions.assertEquals((Object)expectedObject, (Object)actualObject, (String)("getObject for " + columnName));
        }
    }

    private static void compareDimensionSelector(String columnName, DimensionSelector expectedSelector, DimensionSelector actualSelector) {
        Assertions.assertEquals((Object)expectedSelector.nameLookupPossibleInAdvance(), (Object)actualSelector.nameLookupPossibleInAdvance(), (String)("nameLookupPossibleInAdvance for " + columnName));
        Assertions.assertEquals((Object)expectedSelector.supportsLookupNameUtf8(), (Object)actualSelector.supportsLookupNameUtf8(), (String)("supportsLookupNameUtf8 for " + columnName));
        Assertions.assertEquals((Object)(expectedSelector.idLookup() != null ? 1 : 0), (Object)(actualSelector.idLookup() != null ? 1 : 0), (String)("presence of idLookup for " + columnName));
        Assertions.assertEquals((Object)expectedSelector.getObject(), (Object)actualSelector.getObject(), (String)("getObject for " + columnName));
        IntArrayList expectedRow = new IntArrayList();
        IntArrayList actualRow = new IntArrayList();
        expectedSelector.getRow().forEach(arg_0 -> ((IntList)expectedRow).add(arg_0));
        actualSelector.getRow().forEach(arg_0 -> ((IntList)actualRow).add(arg_0));
        Assertions.assertEquals((Object)expectedRow, (Object)actualRow, (String)("getRow for " + columnName));
        for (int i = 0; i < expectedRow.size(); ++i) {
            Assertions.assertEquals((Object)expectedSelector.lookupName(expectedRow.getInt(i)), (Object)actualSelector.lookupName(actualRow.getInt(i)), (String)("lookupName for " + columnName + " id#" + expectedRow.getInt(i)));
            if (!expectedSelector.supportsLookupNameUtf8()) continue;
            Assertions.assertEquals((Object)StringUtils.fromUtf8Nullable((ByteBuffer)expectedSelector.lookupNameUtf8(expectedRow.getInt(i))), (Object)StringUtils.fromUtf8Nullable((ByteBuffer)actualSelector.lookupNameUtf8(actualRow.getInt(i))), (String)("lookupNameUtf8 for " + columnName + " id#" + expectedRow.getInt(i)));
        }
    }

    private static MapBasedInputRow autoRow(List<String> signature, Object ... values) {
        if (signature.size() != values.length) {
            throw new RuntimeException("Signature and values do not match");
        }
        HashMap<String, Object> row = new HashMap<String, Object>();
        for (int i = 0; i < signature.size(); ++i) {
            row.put(signature.get(i), values[i]);
        }
        return new MapBasedInputRow(0L, signature, row);
    }

    static {
        ExpressionProcessing.initializeForTests();
    }
}

