/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.HyperUniquesSerdeForTest;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LargeColumnSupportedComplexColumnSerializerTest {
    private final HashFunction fn = Hashing.murmur3_128();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSanity() throws IOException {
        int[] columnSizes;
        HyperUniquesSerdeForTest serde = new HyperUniquesSerdeForTest(Hashing.murmur3_128());
        int[] cases = new int[]{1000, 5000, 10000, 20000};
        for (int columnSize : columnSizes = new int[]{Integer.MAX_VALUE, 0x3FFFFFFF, 0x1FFFFFFF, 40000, 20000}) {
            for (int aCase : cases) {
                HyperLogLogCollector collector;
                File tmpFile = this.temporaryFolder.newFolder();
                HyperLogLogCollector baseCollector = HyperLogLogCollector.makeLatestCollector();
                try (OffHeapMemorySegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();
                     FileSmoosher v9Smoosher = new FileSmoosher(tmpFile);){
                    LargeColumnSupportedComplexColumnSerializer serializer = LargeColumnSupportedComplexColumnSerializer.createWithColumnSize((SegmentWriteOutMedium)segmentWriteOutMedium, (String)"test", (ObjectStrategy)serde.getObjectStrategy(), (int)columnSize);
                    serializer.open();
                    for (int i = 0; i < aCase; ++i) {
                        collector = HyperLogLogCollector.makeLatestCollector();
                        byte[] hashBytes = this.fn.hashLong((long)i).asBytes();
                        collector.add(hashBytes);
                        baseCollector.fold(collector);
                        serializer.serialize((ColumnValueSelector)new ObjectColumnSelector(){

                            @Nullable
                            public Object getObject() {
                                return collector;
                            }

                            public Class classOfObject() {
                                return HyperLogLogCollector.class;
                            }

                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            }
                        });
                    }
                    try (SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter("test", serializer.getSerializedSize());){
                        serializer.writeTo((WritableByteChannel)channel, v9Smoosher);
                    }
                }
                SmooshedFileMapper mapper = Smoosh.map((File)tmpFile);
                ColumnBuilder builder = new ColumnBuilder().setType(ValueType.COMPLEX).setHasMultipleValues(false).setFileMapper(mapper);
                serde.deserializeColumn(mapper.mapFile("test"), builder, null);
                BaseColumnHolder columnHolder = builder.build();
                ComplexColumn complexColumn = (ComplexColumn)columnHolder.getColumn();
                collector = HyperLogLogCollector.makeLatestCollector();
                for (int i = 0; i < aCase; ++i) {
                    collector.fold((HyperLogLogCollector)complexColumn.getRowValue(i));
                }
                Assert.assertEquals((double)baseCollector.estimateCardinality(), (double)collector.estimateCardinality(), (double)0.0);
            }
        }
    }
}

